	title 'pc1440 diskette handler without login feature'

;    CP/M-80 Version 3     --  Modular BIOS

;	Disk I/O Module for z80 Emulator 

	dseg

    ; Disk drive dispatching tables for linked BIOS

	public	fdpc0,fdpc1,fdpc2,fdpc3

    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?wboot	; warm boot vector
	extrn	?pmsg	; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec	; print binary number in <A> from 0 to 99.
	extrn	?pderr	; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status


    ; Port Address Equates

dsk$cmd 	equ 	0D0h 
dsk$sts 	equ 	0D0h 
dsk$drv		equ	0D1h 	;drv
dsk$trkL	equ	0D2h 	;trkLow
dsk$trkH	equ	0D3h 	;trkHigh
dsk$secL	equ	0D4h 	;secLow
dsk$secH	equ	0D5h 	;secHigh
dsk$dmaL	equ	0D6h 	;dmaLow
dsk$dmaH	equ	0D7h 	;dmaHigh
dsk$sptL	equ	0D8h 	;sptLow
dsk$sptH	equ	0D9h 	;sptHigh
dsk$dmaB	equ	0dah 	;Disk DMA Bank
dsk$ord		equ	0dbh	;disk order

	;disk command constants

cmd$read	equ	1
cmd$write	equ	2
cmd$log		equ	4
cmd$fmt		equ	8

    ; CP/M 3 Disk definition macros

	maclib cpm3

    ; Z80 macro library instruction definitions

	maclib z80

    ; common control characters

cr	equ 13
lf	equ 10
bell	equ 7



    ; Extended Disk Parameter Headers (XPDHs)

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	0,0		; relative drive zero
fdpc0	dph     pctran,dpbpc	;,64,91

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init1
	db	1,0		; relative drive one
fdpc1	dph	pctran,dpbpc	;,64,91

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init2
	db	2,0		; relative drive two
fdpc2	dph	pctran,dpbpc	;,64,91

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init3
	db	3,0		; relative drive three
fdpc3	dph	pctran,dpbpc	;,64,91

	cseg	; DPB must be resident

;dpbsd	dpb 128,26,77,1024,64,2

	db	0,0		;side/cyl/order 0=sides;extra byte
dpbpc	dpb 128,72,160,2048,256,2

	dseg	; rest is banked

;sdtran	skew 26,6,1
pctran	skew 72,1,1

    ; Disk I/O routines for standardized BIOS interface

; Initialization entry point.

;		called for first time initialization.


fd$init0:
fd$init1:	; all initialization done by Emulator
fd$init2:
fd$init3:
	ret


; disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>




;disk executive

dsk$com:
	call	dpb$ad		;hl points to dpb, dpb+0 = SPT
	mov	a,m		;sptLow
	out	dsk$sptL
	inx	hl
	mov	a,m		;sptHigh
	out	dsk$sptH
	dcx	hl
	dcx	hl
	dcx	hl
	mov	a,m		;get order at dpb-2
	out	dsk$ord
	lda	@dma
	out	dsk$dmaL
	lda	@dma+1	
	out	dsk$dmaH
	lda	@dbnk	
	out	dsk$dmaB
	lda	@rdrv
	out	dsk$drv
	lda	@trk
	out	dsk$trkL
	lda	@trk+1
	out	dsk$trkH
	lda	@sect
;	inr	a	;OK because never higher than 72
	out	dsk$secL	
	lda	@sect+1
	out	dsk$secH	
	ret

;read/write addresses above boundry to/from bank 0 (common)

;read sector

fd$read:
	call	dsk$com		;perform common
	mvi	a,cmd$read	
	out	dsk$cmd
	in	dsk$sts		;0=OK - 1=error - 0ffh=media change
	ret

;write sector

fd$write:	
	call	dsk$com		;perform common
	mvi	a,cmd$write
	out	dsk$cmd
	in	dsk$sts		;0=OK - 1=error - 2=Read Only - 0ffh=media change
	ret

;get drv par block address

dpb$ad
	lxi	h,12		;dpb=dph+12
	dad	d		;de -->dph
	mov	a,m		;get dpb from dph at offset 12
	inx	h		;
	mov	h,m		;
	mov	l,a		;hl-->dpb
	ret

fd$login:
	ret	; This entry is called when a logical drive is about to
		; be logged into for the purpose of density determination.

		; It may adjust the parameters contained in the disk
		; parameter header pointed at by <DE>



	end
