/* 
Dload Version 2 for the VMEs10 Emulator
Compile with Alcyon C for CP/M-68k 
*/

#include <stdio.h>
#include <ctype.h>

FILE *fopen();
FILE *fopena();
FILE *fopenb();

/*
ULOAD/DLOAD

$F1A070 - $F1A077

RegUD + offset
'00  01 ro  Download input data port
'02  03 rw  Download input status/control port 0=NOT EOF, 1=EOF / 0xff=rewind file
'04  05 wo  Upload output data port
'06  07 rw  Upload input status/control port 0=NOT EOF, 1=EOF / 0xff=rewind file
*/

#define DLCTRL ((char *)0xf1a073)
#define DLSTS ((char *)0xf1a073)
#define DLDATA ((char *)0xf1a071)

/* void Exit(int code, char * message1, char * message2)*/
Exit(code,message1,message2)
int code;
char *message1;
char *message2;
{
	if (message1 !=0) 
		{
		fprintf (stderr,"\n   %s", message1);
		if (message2 !=0) fprintf (stderr," %s", message2);
		fprintf (stderr,"\n");
		}
	if ( code ==1 ) 
		{
		fprintf (stderr,"\n    Usage: dload [-b|t] <filename> <cr>\n");
		};
	exit (code);
}

/* int main(int argc, char * argv[], char * env[]) */
main(argc,argv)
int argc;
char **argv;
{
FILE *fp;

int cntz;
int InByte;
int fd;
int RecCnt;
int option;
int i;
int ISZ;
char *fn;

fn = NULL;
option = 0; /* 0= binary 1= text */

/*
printf ("Number of Arguments = %d\n", argc);
for ( i=0 ; i < argc ; i++ )
{
printf (" argv[%d]= %s\n",i,argv[i]);
}
*/

printf("\n Dload Version 2.0 for CPM68k on VME10 Emulator\n");

for (i = 1; i < argc; i++)
{
	if (argv[i][0] == '-')
	{
		if ( (argv[i][1] == 't') || (argv[i][1] == 'T') )
			option=1;
		else if ( (argv[i][1] == 'b') || (argv[i][1] == 'B') )
			option=0;
		else
			Exit(1,0,0);
	}
	else
		fn = argv[i];
}			
if (argc < 2 )
{
	Exit(1,0,0);
}
if ( strlen(fn) == 0 )
{
	Exit(1,0,0);
}
	
*DLCTRL = 0xff ; /* Rewind file */

if (*DLSTS != 0) /* EOF == 0 */
{
   Exit(2,"No Dload file open",0);
}
if( (fd = open(fn,0)) == -1 )
{
   if( (fd = creatb(fn,1)) == -1 )
	{
	  Exit(3,"Can't Create ",fn);
	} 
   close(fd);
}
else
{
   close(fd);
   printf("\nFile Exists - Overwrite? (Y or N) - ");
   InByte=getchar();
   printf("\n");
   if ( (InByte != 'Y') && (InByte != 'y' ) ) Exit(0,0,0);
}

if( (fp = fopenb(fn,"w"))==NULL ) 	
{
   Exit(3,"Can't open ",fn);
}

if (option==0)
{
	printf("\n   Downloading as Binary...");

	cntz=0x80;
	RecCnt=0;

	while (*DLSTS == 0)/* NOT EOF*/
	{
		InByte = *DLDATA ;
		if (*DLSTS == 0) /* NOT EOF*/
		{
	 	fputc(InByte,fp);
	 	cntz--;
	 	if (cntz == 0){ cntz = 0x80; RecCnt++; }
		};
	}
	while (cntz !=0 && cntz !=0x80) 
	{
 	fputc(0x1a,fp); cntz--; 
 	if (cntz==0)RecCnt++;
	}
}
if (option==1)
{
	printf("\n   Downloading as Text...");

	cntz=0x80;
	RecCnt=0;
	InByte=0;
	ISZ=0;

	while (*DLSTS == 0 && InByte!=0x1a)
	{
		InByte = *DLDATA ;
		if (*DLSTS == 0) /* NOT EOF*/
		{
		ISZ=(InByte == 0x1a);
	 	fputc(InByte,fp);
	 	cntz--;
	 	if (cntz == 0){ cntz = 0x80; RecCnt++; }
		};
	}
	if (ISZ)
	{
	while (cntz !=0 && cntz !=0x80) 
		{
 		fputc(0x1a,fp); cntz--; 
 		if (cntz == 0)RecCnt++;
		}
	}
	else
	{
	cntz=0x80;
	while (cntz != 0 ) 
		{
 		fputc(0x1a,fp); cntz--; 
 		if (cntz == 0)RecCnt++;
		}
	}
}
fclose(fp);

printf("Finished\n   %d Records Written\n",RecCnt);
}
 
