; This file generates Jade IDTs for all Jade formats support by DD50BIOS
; to install use 
; 
;	dd.exe IF=IDT.bin OF=Jade.IMG bs=128 count=1 

IDT	equ	IDJ50DSDD

IDJ48SSSD	equ	0
IDJ48SSDD	equ	1
IDJ50SSSD	equ	2
IDJ50SSDD	equ	3
IDJ50DSSD	equ	4
IDJ50DSDD	equ	5

	ORG	0x0

;******************************************************
;JADE 48 SPT Single Sided SINGLE DENSITY ID SECTOR
;******************************************************
	if 	IDT eq IDJ48SSSD

ID48.SS	db	"Jade DD SINGLE DENSITY FORMAT "
	org	ID48.SS+020h
	dw	26
	db	3
	db	07h
	db	0
	dw	242
	dw	63
	db	0C0h
	db	0
	dw	16
	dw	2
	org	ID48.SS+030h
	db	6
F48.SS	db	00000010B

	endif
;******************************************************
;JADE 48 SPT Single Sided DOUBLE DENSITY ID SECTOR
;******************************************************
	if 	IDT eq IDJ48SSDD

ID48.SD	db	"Jade DD DOUBLE DENSITY FORMAT "
	org	ID48.SD+020h
	dw	48
	db	4
	db	0fh
	db	1
	dw	224
	dw	63
	db	080h
	db	0
	dw	16
	dw	2
	org	ID48.SD+030h
	db	6
F48.SD	db	00000110B

	endif

;******************************************************
; JADE 50 SPT Single Sided SINGLE DENSITY 
;******************************************************
	if 	IDT eq IDJ50SSSD

ID50.SS	db	"Jade DD S Sided S Density Format "

	org	ID50.SS+20H	;LOCATE CP/M 2.2 DPB.
	dw	26		;SECTORS PER TRACK.
	db	3		;BLOCK SHIFT FACTOR.
	db	7		;BLOCK MASK.
	db	0		;EXM.
	dw	26*75/8-1	;DISK SIZE - 1.
	dw	63		;DIRECTORY MAXIMUM.
	db	11000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	16		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.SS+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.SS	db	00000010B	;DISKETTE FLAGS.

	endif

;******************************************************
; JADE 50 SPT Double Sided SINGLE DENSITY 
;******************************************************
	if 	IDT eq IDJ50DSSD

ID50.DS	db	"Jade DD D Sided S Density Format "

	org	ID50.DS+20H	;LOCATE CP/M 2.2 DPB.
	dw	26		;SECTORS PER TRACK.
	db	4		;BLOCK SHIFT FACTOR.
	db	15		;BLOCK MASK.
	db	1		;EXM.
	dw	26*152/16-1	;DISK SIZE - 1.
	dw	63		;DIRECTORY MAXIMUM.
	db	10000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	16		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.DS+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.DS	db	00001010B	;DISKETTE FLAGS.

	endif

;******************************************************
; JADE 50 SPT SINGLE Sided Double DENSITY 
;******************************************************
	if 	IDT eq IDJ50SSDD

ID50.SD:	db	"Jade DD S Sided D Density Format "

	org	ID50.SD+20H	;LOCATE CP/M 2.2 DPB.
	dw	50		;SECTORS PER TRACK.
	db	4		;BLOCK SHIFT FACTOR.
	db	00001111B	;BLOCK MASK.
	db	1		;EXM.
	dw	50*75/16-1	;DISK SIZE - 1.
	dw	63		;DIRECTORY MAXIMUM.
	db	10000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	16		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.SD+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.SD	db	00000110B	;DISKETTE FLAGS.

	endif

;******************************************************
; JADE 50 SPT Double Sided Double DENSITY 
;******************************************************
	if 	IDT eq IDJ50DSDD

ID50.DD:	db	"Jade DD D Sided D Density Format "

	org	ID50.DD+20H	;LOCATE CP/M 2.2 DPB.
	dw	50		;SECTORS PER TRACK.
	db	5		;BLOCK SHIFT FACTOR.
	db	31		;BLOCK MASK.
	db	3		;EXM.
	dw	50*152/32-1	;DISK SIZE - 1.
	dw	127		;DIRECTORY MAXIMUM.
	db	10000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	32		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.DD+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.DD
	db	00001110B	;DISKETTE FLAGS.

	endif

	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0
	rept	4
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	endm