; -ASM80 ULOAD.ASM
; -LINK ULOAD.OBJ,SYSTEM.LIB TO ULOAD.OUT
; -LOCATE ULOAD.OUT TO ULOAD MAP STACKSIZE(30H)

; -DLOAD ULOAD.ASM
; -COPY ULOAD.LST TO :CO:

	EXTRN	ISIS
	
; Equates for system

open	equ	0
close	equ	1
delete	equ	2
read	equ	3
write	equ	4
seek	equ	5
load	equ	6
rename	equ	7
consol	equ	8
exit	equ	9
attrib	equ	10
rescan	equ	11
error	equ	12
whocon	equ	13
spath	equ	14

faRead	equ	1
faWrit	equ	2
faRW	equ	3

skPos	equ	0
skBwd	equ	1
skLoc	equ	2
skFwd	equ	3
skEof	equ	4

; Equates for ULOAD/DLOAD ports

ULdata	equ	0a2h
ULstat	equ	0a3h
ULcntrl	equ	0a3h

ULrdy	equ	1
ULnrdy	equ	0

ULrew	equ	0ffh

cr	equ	13
lf	equ	10

	DSEG

rACT:	dw	0	;actual number of bytes read

rBuf:	ds	64

;  messages

fly:	db	cr,lf,'Uload Version 1.0 for ISIS',cr,lf
flyL	equ	$-fly
dld:	db	cr,lf,'Uploading ...',cr,lf
dldL	equ	$-dld
nuf:	db	cr,lf,'No Uload File Open',cr,lf
nufL	equ	$-nuf
fne:	db	cr,lf,'File does NOT Exist',cr,lf
fneL	equ	$-fne
fin:	db	cr,lf,'Finished',cr,lf
finL	equ	$-fin
cl:	db	cr,lf,cr,lf
clL	equ	$-cl

wcBuf:	db	'0000h'	;block count
	db	' '
	db	'00h'	;byte count
wcBufL	equ	$-wcBuf

; PBs

pbWcl:	dw	0	;:CO:
	dw	cl	;pointer to crlf
	dw	clL	;count to write
	dw	eStat	;pointer to error status


pbWco:	dw	0	;:CO:
	dw	wcBuf	;pointer to write buffer
wcoCnt:	dw	1	;count to write
	dw	eStat	;pointer to error status

; Write PB
; store aftn for write here after open

fnRead:
pbRead:	dw	0	;actual aftn
	dw	tBuf	;pointer to transfer Buffer
rCount:	dw	1	;Number of bytes read
	dw	rACT	;return of actual count read
	dw	eStat	;pointer to Status

tBuf:	ds	8

; Close PB

fnClos:
pbClos:	dw	0	;Aftn to close
	dw	eStat	;error returned by error

; store error at eStat
; pb for error and exit

eStat:
pbErro:	dw	0	;returned error number
pbExit:	dw	eStat	;error returned by error

	CSEG

Start:	lxi	sp,STACK
	
; write banner

	DSEG

pbWfly:	dw	0	;:CO:
	dw	fly	;pointer to openning banner
	dw	flyL	;count to write
	dw	eStat	;pointer to error status

	CSEG

	mvi	c,write
	lxi	d,pbWfly
	call	ISIS0

; Read from Console PB, used to read cmd line

	DSEG

pbRcon:	dw	1	;:CI:
	dw	rBuf	;pointer to Read Buffer
	dw	32	;Number of bytes to read
	dw	rACT	;return of actual count read
	dw	eStat	;pointer to Status

;read file name from command line

	CSEG

	mvi	c,read
	lxi	d,pbRcon
	call	ISIS0

; test if uload file is open

;	mvi	a,ULrew		;rewind file
;	out	ULcntrl

	in	ULstat
	cpi	ULrdy
	jz	TestFE

; write no uload file open and exit

	DSEG

pbWnuf:	dw	0	;:CO:
	dw	nuf	;pointer to NO Uload File
	dw	nufL	;count to write
	dw	eStat	;pointer to error status

	CSEG

	mvi	c,write
	lxi	d,pbWnuf
	call	ISIS0

	jmp	pExit

; test for file exists 

	DSEG

;Open file PB

pbOpen:	dw	fnRead	;pointer to aftn
	dw	rBuf	;pointer to filename
	dw	faRead	;access value
	dw	0	;echo file aftn
	dw	eStat	;pointer to Status

	CSEG
TestFE:

	mvi	c,open
	lxi	d,pbOpen
	call	ISIS	; need to see non-fatal errors

	lda	eStat
	cpi	0	;no error
	jz	DoIt	

;	not exist

	DSEG

pbWfne:	dw	0	;:CO:
	dw	fne	;pointer to file not exists
	dw	fneL	;count to write
	dw	eStat	;pointer to error status

	CSEG

NotExist:
	mvi	c,write
	lxi	d,pbWfne
	call	ISIS0
	
	jmp	pExit
	
	CSEG

DoIt:

; PB write uploading

	DSEG

pbWdld:	dw	0	;:CO:
	dw	dld	;pointer to uploading
	dw	dldL	;count to write
	dw	eStat	;pointer to error status

	CSEG

; PB write uploading

	mvi	c,write
	lxi	d,pbWdld
	call	ISIS0

while:
	in	ULstat
	cpi	ULrdy
	jnz	EOI

	
; read the buffer

	mvi	c,read
	lxi	d,pbRead
	call	ISIS0

	lhld	rACT
	mov	a,l
	ora	h
	jz	EOI

	lda	tBuf
	out	ULdata

	jmp	while

EOI:

; Close the file

	lhld	fnRead
	shld	fnClos
	mvi	c,close
	lxi	d,pbClos
	call	ISIS0
	
; write finished and exit

	DSEG

pbWfin:	dw	0	;:CO:
	dw	fin	;pointer to finished
	dw	finL	;count to write
	dw	eStat	;pointer to error status

	CSEG

finish:	mvi	c,write
	lxi	d,pbWfin
	call	ISIS0

	jmp	pExit

; Entry to ISIS  

ISIS0:	call	ISIS
	lda	eStat
	ora	a
	rz
	mvi	c,error
	lxi	d,pbErro
	call	ISIS
pExit:	mvi	c,exit
	lxi	d,pbExit
	call	ISIS
; should not return to here

	end	Start
