	PAGE	58,132
	TITLE		'A1 ITFROM'
;-----------------------------------------------------------------------
;
; HISTORY :
;	11-18-1983	DELETE EXCESSIVE INIT. OF SYSCOM AREA.
;	11-21-1983	DECLARATIN OF MDPSD (SOUND BEEP) --- ADDED.
;	12-09-1983	ROM SUM CHECK ERROR -> HALT
;	02-10-1984	MODIFY GDC-SYNC COMMAND
;	02-27-1984	DISABLE DISPLAY
;	03-20-1984	MODIFICATIONS FOR FIRST RELEASE (FD VERSION)
;	(1) DELETE "BREAK KEY SENSE" TO SEE IF WARM BOOT
;	(2) ADD SELECTION OF BOOT UNIT/VOLUME (SETING SYS_SEL)
;	(3) ADD AUTO MEMORY SIZING (RATHER THAN USING CMOS)
;	04-23-1984	SEPARATE WARM BOOT PROCEDURE FOR HD VERSION
;	04-24-1984	SOURCE MODIFICATION FOR PATCH.
;			(GDC SYNC PARAMETER, FOR 80CRT=HOME TV.)
;
;-----------------------------------------------------------------------
	INCLUDE	B:EQCOM.LIB
;
;------------------------------------------------------
;	EQU for key codes (03-20-1984 : added)
;------------------------------------------------------
;
FNC_KEY		equ	75h	; Fnc key scan code
PF1_KEY		equ	62h	; PF1 key scan code
PF12_KEY	equ	6dh	; PF12 key scan code
;
;----------------------------------------------------------
;
;	EXTRNAL/PUBLICS
;
;----------------------------------------------------------
;
	EXTRN	ROM_INIT:NEAR		; INITIALIZE ENTRY
					; FOR ROM BIOS.
;
	PUBLIC	MDXI1			; EOI ROUTINE ENTRYY
	PUBLIC	MDPSD			; SOUND BEEP ROUTINE ENTRY
;
	PAGE
;----------------------------------------------------------
;
;	STACK USAGE : ITF USES SECOND HALF VECTOR AREAS
;
;----------------------------------------------------------
;
ITF_STACK	SEGMENT	AT ITF_USE_STACK_SEG
STACK	DB	256 DUP (?)	; #128 -- #255
TOP	EQU	WORD PTR ($-2)	; POINTS LAST WORD
ITF_STACK	ENDS
;
	PAGE
;-----------------------------------------------------------
;
;	DATA SEGMENT (MUST BE IN RAM)
;
;-----------------------------------------------------------
;
	INCLUDE B:SYSCOM.LIB
;
	PAGE
;-------------------------------------------
;
;	CODE SEGMENT
;
;-------------------------------------------
;
ROM	SEGMENT	WORD	PUBLIC
	ASSUME	CS:ROM,DS:SYSCOM,ES:SYSCOM,SS:SYSCOM
;
;********************************************************
;*					10-18-1983	*
;*	CONTENTS OF INITIAL TEST FIRMWARE (ITF)		*
;*	 						*
;*	   1. 8086 CPU TEST				*
;*	   2. TEXT GDC(7220) INLZ(1)			*
;*	   3. SYSTEM PORT INLZ				*
;*	   4. ROM SUM CHECK				*
;*	   5. TIMER(8253) TEST & INLZ			*
;*	   6. DMA(8237) TEST & INLZ			*
;*	   7. JUDGE WARM/COLD START			*
;*	   8. BASIC RAM 128KB TEST & INLZ		*
;*	   9. HW TYPE (5/8MHZ,A1/AWS TYPE) INLZ		*
;*	  10. PIC(8259) TEST & INLZ			*
;*	  11. INT VECTOR TABLE INLZ			*
;*	  12. TEXT GDC(7220) INLZ(2)			*
;*	  13. GRAPH GDC(7220) INLZ			*
;*	  14. VRAM TEST & INLZ 				*
;*	  15. NON VOLATILE MEMORY INLZ			*
;*	  16. EXTENDED RAM(MAX 512KB) TEST & INLZ	*
;*	  17. MISC					*
;*              (1) NMI INT PROCESS			*
;*		(2) SYSTEM DEFAULT INT PROCESS		*
;*							*
;********************************************************
PAGE
;*---------------------------------- 04-23-1984 (ADDED) --
;*
;*	COLD / WARM BOOT PROCEDURE ENTRY POINT
;*
;*--------------------------------------------------------
COLD_BOOT:
	JMP	MDA00		; COLD, START FROM CPU TEST
WARM_BOOT:
	JMP	WARM00		; WARM, SKIP CPU TEST
;
;---------------------------------- 04-23-1984 -----------
;
PAGE
;****************************************
;*					*
;*	8086 CPU BASIC TEST		*
;*					*
;****************************************
MDA00:	CLI			;IF:=0
	MOV	AH,0D5H
	SAHF
	JNS	MDAER0		;SF=0 ?
	JNZ	MDAER0		;ZF=0 ?
	JNP	MDAER0		;PF=0 ?
	JNB	MDAER0		;CF=0 ?
	CLC			;CF:=0
	AAS			;CF:=AF
	JNB	MDAER0
;
	MOV	AL,1
	MOV	AH,2
	MUL	AH
	JO	MDAER0		;OF=1 ?
;
	XOR	AX,AX		;AX:=0
	SAHF			;SF,ZF,AF,PF,CF:=0
	JS	MDAER0		;SF=1 ?
	JZ	MDAER0		;ZF=1 ?
	JP	MDAER0		;PF=1 ?
	JB	MDAER0		;CF=1 ?
	STC			;CF:=1
	AAS			;CF:=AF
	JB	MDAER0
;
	MOV	AL,7FH
	MOV	AH,32
	MUL	AH
	JNO	MDAER0		;OF=0 ?
	JMP	SHORT	MDA01
MDAER0:	HLT			;ERROR(COND JUMP)
;
;
MDA01:	MOV	AX,0FFFFH	;INLZ TEST PATTERN
MDA02:	MOV	DS,AX
	MOV	BX,DS
	MOV	SS,BX
	MOV	CX,SS
	MOV	ES,CX
	MOV	DX,ES
	MOV	SP,DX
	MOV	BP,SP
	MOV	SI,BP
	MOV	DI,SI
	CMP	DI,AX
	JE	MDA03
	HLT			;ERROR(REG MOVE)
MDA03:	OR	DI,DI
;---------------------------------- 04-23-1984 (CHANGED) -----
	JZ	MDA04		;JMP IF ALL PATTERN END
;-------------------------------------------------------------
	SUB	AX,5555H	;FF --> AA --> 55 --> 00
	JMP	SHORT	MDA02
;--------------------------------- 04-23-1984 (ADDED) --------
;*********************************
;	COLD BOOT PROCEDURE
;*********************************
MDA04:	XOR	AX,AX		; INDICATE COLD BOOT
	MOV	SS,AX
	JMP	SHORT MDSX0	; GO TO COMMON PROCEDURE
;*********************************
;	WARM BOOT PROCEDURE
;*********************************
WARM00:	MOV	AX,1		; INDICATE WARM BOOT
	MOV	SS,AX
;
;-------------------------------------------------- 04-23-1984 ---------------
PAGE
;****************************************
;*					*
;*	TEXT GDC INITIALIZE (1)		*
;*					*
;****************************************
MDSX0:
;----------------------------------------------------------------02/27/1984----
	MOV	AL,CRT_DISP_NE
	OUT	CRT_FF,AL	; DISP DISABLE
;------------------------------------------------------------------------------
	MOV	BX,OFFSET GDCM_8X_RESET
	MOV	AH,60H
	MOV	SP,OFFSET MDSX1
	JMP	MDS00		; RESET MASTER GDC(7220)
;
MDSX1:	MOV	BX,OFFSET GDCM_8X_MASTER
	MOV	AH,20H
	MOV	SP,OFFSET MDSX2
	JMP	MDS00		; MASTER SET
;
MDSX2:	MOV	BX,OFFSET GDCM_88_SYNC
	IN	AL,PORTB
	TEST	AL,CRT_TYPE_SENSE
	JNZ	MDSX3		; JMP IF 88 CRT
	MOV	BX,OFFSET GDCM_80_SYNC
MDSX3:	MOV	AH,20H
	MOV	SP,OFFSET MDSX4
	JMP	MDS00		; SET SYNC CMD TO MASTER GDC
;
MDSX4:	MOV	AH,CRT_FF_88	; DT1
	IN	AL,PORTB
	TEST	AL,CRT_TYPE_SENSE
	JNZ	MDSX5		; JMP IF 88 CRT
	MOV	AH,CRT_FF_80	; DT0
MDSX5:	MOV	AL,AH
	OUT	CRT_FF,AL	; 88GRP MODE SET
PAGE
;****************************************
;*					*
;*	SYSTEM PORT INITIALIZE		*
;*					*
;****************************************
MDG00:	MOV	AL,44H
	OUT	DMA_CMD,AL	;DMA CONTROLLER DISABLE
	MOV	AL,92H		;INITIALIZE SYSTEM PORT
	OUT	SYS_PORT,AL	;MODE0,A=IN,B=IN,C=OUT
	MOV	AL,07H
	OUT	SYS_PORT,AL	;RESET SPEAKER
	OUT	50H,AL		;RESET NMI F/F
PAGE
;****************************************
;*					*
;*	ROM SUM CHECK (1)		*
;*	 32KB (ADRS:F8000H -- FFFFFH)	*
;*					*
;****************************************
	MOV	AX,0F000H
	MOV	ES,AX
	XOR	AX,AX
	MOV	BX,8000H	;BX:=RELATIVE ADDRESS
	MOV	CX,4000H	;LOOPCOUNT=16K
MDG01:	ADD	AL,ES:[BX]	;ACCUMULATE EVEN BYTES
	INC	BX
	ADD	AH,ES:[BX]   	;ACCUMULATE ODD BYTES
	INC	BX
	LOOP	MDG01
	OR	AX,AX
	JZ	MDB00
	HLT			;HALT 
PAGE
;****************************************
;*					*
;*	TIMER(8253) TEST AND INLZ	*
;*					*
;****************************************
;
;*****CHECK TIMER 1,2
;
MDB00:	MOV	BX,0010H	;SAVE TIMER0 CONTROL WORDS
	MOV	SI,4050H	;SAVE TIMER1 CONTROL WORDS
	MOV	DI,8090H	;SAVE TIMER2 CONTROL WORDS
	MOV	CX,3
	MOV	DX,TIMER0	;DX:=TIMER0 CODE
MDB01:	MOV	BP,0FFFFH	;SET TEST PATTERN
MDB02:	MOV	AL,BL		;WRITE CONTROL WORD
	OUT	TIM_CTL,AL	;LSB,MODE0,BINARY
	NOP
	MOV	AX,BP
	OUT	DX,AL		;WRITE DATA
	NOP
	MOV	AL,BH
	OUT	TIM_CTL,AL	;WRITE CONTROL WORD(LATCH)
	NOP			; TIMING ADJUST
	NOP
	IN	AL,DX		;READ DATA
	CMP	AH,AL
	JNZ	MDB03		;TIMER CORRECT ?
	HLT			;ERROR(TIMER)
MDB03:	CMP	AH,0
	JZ	MDB04
	MOV	BP,0		;SET TEST PATTERN
	JMP	SHORT	MDB02
MDB04:	INC	DX
	INC	DX	
	MOV	BX,SI
	MOV	SI,DI
	LOOP	MDB01
;
;***** INITIALIZE TIMER
;
;      INITIALIZE TIMER0 (INTERVAL TIMER)
;
	MOV	AL,30H		;WRITE TIMER0 CONTROL WORD
	OUT	TIM_CTL,AL	;LSB,MSB,MOD0,BINARY
;
;      INITIALIZE TIMER1 (MEMORY REFRESH)
;
	MOV	AL,54H		;WRITE TIMER1 CONTROL WORD
	OUT	TIM_CTL,AL	;LSB,MOD2,BINARY
	MOV	AH,70
	IN	AL,PORTA		;READ SYSTEM PORT
	TEST	AL,40H			;CHECK CPU CLOCK
	JZ	MDB05			;JMP IF 5MHZ TYPE
	MOV	AH,57
MDB05:	MOV	AL,AH
	OUT	TIMER1,AL	;WRITE LSB
;
;      INITIALIZE TIMER2 (RS-232C)
;
	MOV 	AL,0B6H		;WRITE TIMER2 CONTROL WORD
	OUT	TIM_CTL,AL	;LSB,MSB,MOD3,BINARY
PAGE
;****************************************
;*					*
;*	DMA(8237) TEST AND INLZ		*
;*					*
;****************************************
	OUT	DMA_MCL,AL	; MASTER CLEAR
;*****  INITIALIZE BANK REG
	XOR	AL,AL
	OUT	27H,AL		; BANK REG FOR CH0
	OUT	23H,AL		; BANK REG FOR CH2
	OUT	25H,AL		; BANK REG FOR CH3
;
;***** CHECK ADDRESS AND COUNT REGISTERS OF 4 CHANNELS
;
	MOV	AL,0FFH
MDC01:	MOV	DX,1
	MOV	CX,8
	MOV	BL,AL
	MOV	BH,BL	
MDC02:	OUT	DX,AL		;WRITE ADDRESS OR COUNT
	OUT	DX,AL
	NOP
	MOV	AX,DX		;CHANGE AX PATTERN
	IN	AL,DX		;READ ADDRESS OR COUNT
	MOV	AH,AL		
	IN	AL,DX
	CMP	BX,AX
	JNZ	MDCER0
	INC	DX
	INC	DX
	LOOP	MDC02
	OR	AL,AL
	JZ	MDC03
	MOV	AL,0
	JMP	SHORT	MDC01
MDCER0:	HLT			;ERROR(DMA)
;
;*****INITIALIZE DMA
;
MDC03:	MOV	AL,0FFH
	OUT	07H,AL		;WRITE DMA1 BASE AND CURRENT COUNT
	OUT	07H,AL
	MOV	AL,59H
	OUT	DMA_MOD,AL	;WRITE DMA1 MODE
	MOV 	AL,40H
	OUT	DMA_CMD,AL	;CONTROLLER ENABLE
	OUT	DMA_MOD,AL	;WRITE DMA0 MODE
	MOV	AL,42H
	OUT	DMA_MOD,AL	;WRITE DMA2 MODE
	INC	AL
	OUT	DMA_MOD,AL	;WRITE DMA3 MODE
	MOV	AL,1
        OUT	DMA_MSK,AL	;DMA1 MASK OFF
PAGE
;****************************************
;*					*
;*	JUDGE WARM/COLD START		*
;*					*
;****************************************
;
;---------------------------------- 04-23-1984 (ADDED) -----------------
	MOV	AX,SS		; GET FLAG
	TEST	AX,01H		; SEE COLD OR WARM
	JZ	MDD50		; COLD, DO BOOT VOLUME/UNIT SENSE
	JMP	MDD56		; WARM, SKIP IT
;---------------------------------- 04-23-1984 -------------------------
;
;   (1) INITIALIZE KB INTERFACE
MDD50:	MOV	AL,02H
	OUT	KB_CMD,AL
	MOV	CX,4
	LOOP	$			;WAIT FOR TIMING ADJUST
	MOV	AL,40H
	OUT	KB_CMD,AL	;IR:=1
	MOV	CX,4
	LOOP	$			;WAIT FOR TIMING ADJUST
	MOV	AL,5EH
	OUT	KB_MOD,AL	;SET MODE
	MOV	CX,4
	LOOP	$			;WAIT FOR TIMING ADJUST
	MOV	AL,3AH
	OUT	KB_CMD,AL	;RST:=1
	MOV	CX,0060H	;WAIT 160 MICROSEC
	LOOP	$
	MOV	AL,32H
	OUT	KB_CMD,AL	;RST:=0
	MOV	CX,0040H	;WAIT 107 MICROSEC
	LOOP	$
	MOV	AL,16H
	OUT	KB_CMD,AL	;RXE:=1
;----------------------------- 03-20-1984 (deleted) -----------------
;
;   (2) JUDGE WHETER "STOP" KEY DEPRESSED OR NOT
;
;	MOV	AH,60H			;STOP KEY CODE [A1]
;	IN	AL,PORTA		;READ SYSTEM PORT
;	TEST	AL,20H			;CHECK SYSTEM TYPE
;	JZ	MDD52			;JUMP IF A1
;	MOV	AH,36H			;RESET KEY CODE [AWS]
;MDD52:
;	MOV	BL,3
;	MOV	CX,2000H	;IF RXRDY=0,WAIT 30MS
;MDD53:	IN	AL,KB_STA
;	TEST	AL,02H		;RXRDY=1 ?
;	JNZ	MDD54
;	LOOP	MDD53
;	JMP	SHORT	MDD00		;NOT DEPRESSED ANY KEY (COLD START)
;MDD54:	MOV	CX,12		;WAIT 18 MICROSEC
;MDD55:	LOOP	MDD55
;	IN	AL,KB_DATA	;READ CODE
;	CMP	AL,AH			;CODE=STOP KEY ?
;	JE	MDD56
;	DEC	BL
;	JNZ	MDD53
;	JMP	SHORT	MDD00		; NOT DEPRESSED "STOP" KEY (COLD START)
;---------------------------------- 03-20-1984 (deleted to here) ------
;
;---------------------- 03-20-1984 (added new process) -----------
;
;	Sense Fnc, PF1 - PF12 and set SYS_SEL for BOOTROM
;
;-----------------------------------------------------------------
;
;
;--- COLD BOOT, SENSE KEYS DEPRESSED (INDICATE BOOT UNIT/VOLUME)
;
	MOV	BL,4		; REPEAT 4 TIMES, SINCE A1 HAS 3 LOCK KEYS.
MDD51:				; repeat from this point !
	MOV	CX,2000H	; IF RXRDY = 0, WAIT 30 MS.
MDD53:
	IN	AL,KB_STA
	TEST	AL,02H		; RXRDY = 1 ?
	JNZ	MDD54
	LOOP	MDD53		; WAIT
	MOV	AH,0		; SET VALUE = 0
	JMP	SHORT MDD553	; NO KEY IS DEPRESSED.
MDD54:
	MOV	CX,12		; WAIT 18 MS.
MDD55:
	LOOP	MDD55
	IN	AL,KB_DATA	; READ CODE
;
	CMP	AL,FNC_KEY	; FNC ?
	JNE	MDD551		; NO, SEE IF PF1 - PF12
	MOV 	AH,80H		; SET VALUE = 80H
	JMP	SHORT MDD553	; FNC KEY IS DEPRESSED.
MDD551:
	CMP	AL,PF1_KEY
	JL	MDD552		; OUT OF RANGE
	CMP	AL,PF12_KEY
	JA	MDD552		; OUT OF RANGE
;
;--- WITHIN PF1 - PF12, SET (1--12).
;
	SUB	AL,PF1_KEY-1	; CONVERT TO 1 - 12
	MOV	AH,AL		; SET VALUE = X
	JMP	SHORT MDD553	; PF1 - PF12 KEY DEPRESSED.
;
;--- OTHER KEY (RETRY 4 TIMES)
;
MDD552:
	DEC	BL
	JNZ	MDD51		; REPEAT 4 TIMES
	MOV	AH,0		; NO FNC, OR PF1-PF12 WITHIN 4 TIMES
;
;--- SET SYS_SEL, AND GO TO COLD BOOT PROC.
;
MDD553:
	MOV	BP,AX		; SAVE AH VALUE, TO THE
				; END OF MEMORY INITIALIZATION.
;----------------------------------04-23-1984 (ADDED) -------------
	JMP	SHORT MDD00	; GO TO BASIC 128 KB TEST
;------------------------------------------------------------------
;
;--------------------------------- 03-20-1984 (ADDED TO HERE) -----
;
;
;   (3) WARM START PROCESS (CLEAR BIOS AREA)
MDD56:	XOR	AX,AX
	MOV	DS,AX
	MOV	ES,AX
	MOV	DI,OFFSET DISK_BOOT	;--- CHANGED 11-18-1983 ----
	MOV	CX,0FFH			;--- CHANGED 11-18-1983 ----
	CLD
REP 	STOSW			;CLEAR 256 BYTES
	OR	BYTE PTR BIOS_FLAG,80H	;SET WARM BIT
;---------------------------------- 04-23-1984 (ADDED) -----
	MOV	BP,0		; INDICATE SYS_SEL SHOULD NOT BE CHANGED
;-----------------------------------------------------------
	JMP	MDD06		;SKIP BASIC 128KB RAM R/W TEST
PAGE
;****************************************
;*					*
;*	BASIC 128KB R/W TEST		*
;*	    AND INITIALIZE		*
;*					*
;****************************************
;
;   (1) DUMMY WRITE 2 TIMES FOR DYNAMIC RAM INLZ
MDD00:	CLD
	XOR	AX,AX
	XOR	BX,BX
	MOV	SI,4
	MOV	DX,8000H
MDD01:	MOV	CX,DX
	MOV	ES,BX
	XOR	DI,DI
REP	STOSW		
	DEC	SI
	JZ	MDD02
	CMP	SI,2
	JG	MDD01
	MOV	BX,1000H
	JMP	SHORT	MDD01
;
;   (2) R/W TEST FOR BASIC 128KB RAM
MDD02:	MOV	AX,0FFFFH	; INLZ TEST PATTERN
MDD03:	XOR	BX,BX
	MOV	SI,2
MDD04:	MOV	CX,DX
	XOR	DI,DI
	MOV	ES,BX
REP	STOSW				; WRITE TEST PATTERN
	MOV	BX,1000H
	DEC	SI
	JNZ	MDD04
;
	XOR	BX,BX
	MOV	SI,2
MDD05:	MOV	CX,DX
	XOR	DI,DI
	MOV	ES,BX
REPE	SCASW			; READ TEST PATTERN
	JNE	MDDER		; JMP IF ERR
	MOV	BX,1000H
	DEC	SI
	JNZ	MDD05
	OR	AX,AX
	JZ	MDD06		; JMP IF ALL PATTERN END
	SUB	AX,5555H	; FF --> AA --> 55 --> 00
	JMP	SHORT	MDD03
MDDER:	HLT			; ERR (BASIC 128KB RAM)
;
;   (3) DS,SS,SP INLZ (NOW WE CAN USE STACK AREA !!)
MDD06:	MOV	AX,30H
	MOV	SS,AX
	MOV	SP,0FEH
	XOR	AX,AX
	MOV	DS,AX
;
;-------------- 03-20-1984 (I) -------------------------
;
	MOV	AX,BP		; RECOVER AH VALUE
				; (SELECTION OF BOOT UNIT/VOLUME)
	MOV	SYS_SEL,AH	; SET THE SELECTED VALUE.
;-------------------------------------------------------
PAGE
;****************************************
;*					*
;*	HW TYPE INITIALIZE		*
;*	   5/8MHZ TYPE			*
;*	  A1/AWS TYPE			*
;*					*
;****************************************
	AND	BYTE PTR BIOS_FLAG+1,3FH
	IN	AL,PORTA		;READ SYSTEM PORT
	SAL	AL,1			;AJUST BIOS_FLAG FORM
	AND	AL,0C0H			;MASK CLOCK,SYSTEM BIT
	OR	BYTE PTR BIOS_FLAG+1,AL	;SET CLOCK,SYSTEM BIT
PAGE
;****************************************
;*					*
;*	INT CONTROLLER(8259)		*
;*		TEST AND INLZ		*
;*					*
;****************************************
;
;***** INITIALIZE INT MASTER
;
MDE00:	CLI
	MOV	AL,11H
	OUT	INTM_I1,AL	;WRITE ICW1
	MOV	AL,08H
	OUT	INTM_I2,AL	;WRITE ICW2
	MOV	AL,80H
	OUT	INTM_I3,AL	;WRITE ICW3
	MOV	AL,1DH
	OUT	INTM_I4,AL	;WRITE ICW4
;
;***** INITIALIZE INT SLAVE
;
	MOV	AL,11H
	OUT	INTS_I1,AL	;WRITE ICW1
	MOV	AL,10H
	OUT	INTS_I2,AL	;WRITE ICW2
	MOV	AL,07H
	OUT	INTS_I3,AL	;WRITE ICW3
	MOV	AL,09H
	OUT	INTS_I4,AL	;WRITE ICW4
;
;***** CHECK IMRS WITH ALL0 AND ALL1 PATTERN
;
	MOV	AX,0		;SET AH,AL=0
MDE01:	OUT	INTM_O1,AL	;WRITE IMR
	NOP
	IN	AL,INTM_O1	;READ IMR
	CMP	AH,AL
	JZ	MDE02
	HLT			;ERROR(MASTER IMR REG)
MDE02:	OUT	INTS_O1,AL	;WRITE IMR
	NOP
	IN	AL,INTS_O1	;READ IMR
	CMP	AH,AL
	JZ	MDE03
	HLT			;ERROR(SLAVE IMR REG)
MDE03:	OR	AX,AX
	JNZ	MDE04		;IMR TEST END ?
	NOT	AX		;SET AH,AL=FF
	JMP	SHORT	MDE01
;
;***** SET TEMPORARY INTERRUPT VECTOR 8  
;
MDE04:	XOR	AX,AX
	MOV	ES,AX
	CLD
	MOV	DI,20H
	MOV	AX,OFFSET MDEINT
	STOSW				;WRITE VECTOR
	MOV	AX,SEG MDEINT
	STOSW				;WRITE VECTOR
;
;***** TEST TIMER INTERRUPT
;
	MOV	CX,20H
	XOR	AH,AH		;INLZ INT FLAG
	STI
MDE06:	TEST	AH,0FFH		;NO INTERRUPT EXPECTED
	JZ	MDE07
	CLI
	HLT			;ERROR(UNEXPECTED INTERRUPT)
MDE07:	LOOP	MDE06
;
;
	MOV	AL,32
	TEST	BYTE PTR BIOS_FLAG + 1,80H
	JZ	MDE08		; JMP IF 5MHZ TYPE
	MOV	AL,26
MDE08:	OUT	TIMER0,AL	;TIMER=13 MICROSEC
	NOP
	XOR	AX,AX
	OUT	TIMER0,AL
	MOV	CX,20H
	MOV	AL,0FEH
	OUT	INTM_O1,AL	;TIMER MASK OFF
MDE09:	TEST	AH,0FFH		;INTERRUPT EXPECTED
	JNZ	MDE0A
	LOOP	MDE09
	CLI
	HLT			;ERROR(TIMER INTERRUPT)
MDE0A:	XOR	AL,AL
	OUT	TIMER0,AL
	NOP
	OUT	TIMER0,AL
	JMP	SHORT	MDX00
;
;********************************
;*  TEMPORARY TIMER INT RTN	*
;********************************
;
MDEINT:	MOV	AH,0FFH		;INT FLAG ON
	MOV	AL,0FFH
	OUT	INTM_O1,AL	;IMR(M):=FF
	MOV	AL,EOI
	OUT	INTM_O2,AL	;WRITE EOI TO MASTER
	IRET
PAGE
;****************************************
;*					*
;*	INT VECTOR TABLE INLZ		*
;*	  ENTRY FROM 0 TO 1DH		*
;*					*
;****************************************
;
;***** VECTOR 0 TO 7
;
MDX00:	XOR	AX,AX
	MOV	ES,AX
	CLD
	XOR	DI,DI
	MOV	CX,8
MDX01:	MOV	AX,OFFSET MDXI0
	STOSW		
	MOV	AX,SEG MDXI0
	STOSW		
	LOOP	MDX01
;
;***** VECTOR 8 TO 17H
;
	MOV	CX,16
MDX02:	MOV	AX,OFFSET MDXI1
	STOSW		
	MOV	AX,SEG MDXI1
	STOSW		
	LOOP	MDX02
PAGE
;****************************************
;*					*
;*	TEXT GDC INITIALIZE (2)		*
;*					*
;****************************************
MDSX10:
	IN	AL,PORTB	;READ SYSTEM PORT B
	TEST	AL,08H		;CHECK CRT TYPE
	JNZ	MDSX11		;JUMP IF 88
	MOV	AL,00H
	OUT	70H,AL		;PL
	MOV	AL,07H
	OUT	72H,AL		;BL
	MOV	AL,08H
	OUT	74H,AL		;CL
	MOV	AL,06H
	OUT	68H,AL		;6*7 FONT
	MOV	BX,OFFSET GDCM_80_CSR
	JMP	SHORT	MDSX12
MDSX11:
	MOV	AL,00H
	OUT	70H,AL		;PL
	MOV	AL,0FH
	OUT	72H,AL		;BL
	MOV	AL,10H
	OUT	74H,AL		;CL
	MOV	AL,07H
	OUT	68H,AL		;7*11 FONT
	MOV	BX,OFFSET GDCM_88_CSR
MDSX12:
	MOV	AH,0
	CALL	MDS00
	MOV	AL,00H
	OUT	76H,AL		;INLZ M/S SSL
	MOV	AL,01H
	OUT	68H,AL		;SEMI GRAPHIC MODE
	MOV	AL,04H
	OUT	68H,AL		;80 CHR
;
	MOV	BX,OFFSET GDCM_8X_PITCH
	MOV	AH,0
	CALL	MDS00		;PITCH CMD
;
	MOV	BX,OFFSET GDCM_8X_ZOOM
	MOV	AH,0
	CALL	MDS00		;ZOOM CMD
;
	MOV	BX,OFFSET GDCM_8X_SCROLL
	MOV	AH,0
	CALL	MDS00		;SCROLL CMD
PAGE
;****************************************
;*					*
;*	GRAPH GDC INITIALIZE		*
;*					*
;****************************************
	MOV	BX,OFFSET GDCS_8X_RESET
	MOV	AH,0C0H
	CALL	MDS00		; RESET SLAVE GDC (7220)
;
MDSX13:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JZ	MDSX13		; EXIT IF VSYNC(MASTER)=1
MDSX14:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JNZ	MDSX14		; EXIT IF VSYNC(MASTER)=0
;
	MOV	BX,OFFSET GDCS_8X_SLAVE
	MOV	AH,80H
	CALL	MDS00		; SET SLAVE
;
	MOV	CX,2
MDSX15:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JZ	MDSX15		; EXIT IF VSYNC(MASTER)=1
MDSX16:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JNZ	MDSX16		; EXIT IF VSYNC(MASTER)=0
	LOOP	MDSX15		; SYNC 2 TIMES
;
	MOV	BX,OFFSET GDCS_88_SYNC
	IN	AL,PORTB
	TEST	AL,CRT_TYPE_SENSE
	JNZ	MDSX20		; JMP IF 88CRT
	MOV	BX,OFFSET GDCS_80_SYNC
MDSX20:	MOV	AH,80H
	CALL	MDS00		; SYNC CMD
;
	MOV	BX,OFFSET GDCS_88_CSR
	IN	AL,PORTB
	TEST	AL,CRT_TYPE_SENSE
	JNZ	MDSX21
	MOV	BX,OFFSET GDCS_80_CSR
MDSX21:	MOV	AH,80H
	CALL	MDS00		; CSRFORM CMD
;
	MOV	BX,OFFSET GDCS_8X_PITCH
	MOV	AH,80H
	CALL	MDS00		; PITCH CMD
;
	MOV	BX,OFFSET GDCS_8X_ZOOM
	MOV	AH,80H
	CALL	MDS00		; ZOOM CMD
;
	MOV	BX,OFFSET GDCS_8X_SCROLL
	MOV	AH,80H
	CALL	MDS00		; SCROLL CMD
;
	MOV	BX,OFFSET GDCS_8X_TEXTW
	MOV	AH,80H
	CALL	MDS00		; TEXTW CMD
;
	MOV	BX,OFFSET GDCS_8X_CODEW
	MOV	AH,80H
	CALL	MDS00		; CODEW CMD
;
	MOV	AL,0
	OUT	CRT_BORD,AL	; INLZ BORDER COLOR
;
MDSX30:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JNZ	MDSX30		; EXIT IF VSYNC(MASTER)=0
MDSX31:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JZ	MDSX31		; EXIT IF VSYNC(MASTER)=1
MDSX32:	IN	AL,GDC_M_STA
	TEST	AL,GDC_VSYNC
	JNZ	MDSX32		; EXIT IF VSYNC(MASTER)=0
;
MDSX33:	IN	AL,GDC_S_STA
	TEST	AL,GDC_VSYNC
	JNZ	MDSX33		; EXIT IF VSYNC(SLAVE)=0
MDSX34:	IN	AL,GDC_S_STA
	TEST	AL,GDC_VSYNC
	JZ	MDSX34		; EXIT IF VSYNC(SLAVE)=1
MDSX35:	IN	AL,GDC_S_STA
	TEST	AL,GDC_VSYNC
	JNZ	MDSX35		; EXIT IF VSYNC(SLAVE)=0
;
	MOV	AL,GDC_START
	OUT	GDC_S_CMD,AL	; DISP START (SLAVE)
	OUT	GDC_M_CMD,AL	; DISP START (MASTER)
;
MDSX36:	IN	AL,GDC_S_STA
	TEST	AL,GDC_VSYNC
	JZ	MDSX36		; EXIT IF VSYNC(SLAVE)=1
;
	MOV	AL,GDC_STOP
	OUT	GDC_S_CMD,AL	; DISP STOP (SLAVE)
	OUT	GDC_M_CMD,AL	; DISP STOP (MASTER)
;
;   INLZ MODE F/F
	MOV	AL,CRT_FF_COLOR
	OUT	CRT_FF,AL	; SET GRAPHIC MODE
;
;   INLZ PALETTE REGISTER
	MOV	AL,37H
	OUT	CRT_COLR_67,AL	; PALETTE REG 6,7
	MOV	AL,15H
	OUT	CRT_COLR_45,AL	; PALETTE REG 4,5
	MOV	AL,26H
	OUT	CRT_COLR_23,AL	; PALETTE REG 2,3
	MOV	AL,04H
	OUT	CRT_COLR_01,AL	; PALETTE REG 0,1
;
MDSX38:	MOV	AL,CRT_DISP_E
	OUT	CRT_FF,AL	; DISP ENABLE
PAGE
;****************************************
;*					*
;*	TEXT,GRAPH VRAM R/W TEST	*
;*	     AND INITIALIZE		*
;*					*
;****************************************
	TEST	BYTE PTR BIOS_FLAG,80H
	JZ	MDSX40
	JMP	MDH00		; SKIP VRAM R/W TEST IF WARM START
;
;   DYNAMIC GRAPH VRAM 192KB DUMMY WRITE 2 TIMES
MDSX40:
	AND	BYTE PTR BIOS_FLAG+1,0F7H	;RESET OPTION VRAM BIT
	MOV	AX,0B000H		;OPTION VRAM BASE
	MOV	ES,AX
	MOV	AL,0			;P10,P20,P30 ACCESS
	OUT	0A6H,AL			;WRITE PLANE REG
	MOV	ES:WORD PTR [0],05555H	;WRITE PATTERN
	CMP	ES:WORD PTR [0],05555H	;READ PATTERN
	JNE	MDSX45			;JUMP IF NOT EQ
	MOV	ES:WORD PTR [0],0AAAAH
	CMP	ES:WORD PTR [0],0AAAAH
	JNE	MDSX45
	OR	BYTE PTR BIOS_FLAG+1,08H	;SET OPTION VRAM BIT
MDSX45:
	XOR	DX,DX		; PATTERN
	CALL	MDS60W
	CALL	MDS60W
;
;   TEXT VRAM R/W TEST
;
MDSX60:
	MOV	AX,0A000H	;TEXT VRAM BASE
	MOV	ES,AX
	MOV	DL,0FFH		; INLZ TEST PATTERN
MDSX61:
	XOR	DI,DI
	MOV	CX,2000H
	MOV	AL,DL
	REP	STOSW
	XOR	DI,DI
	MOV	CX,1FF0H
MDSX62:	CMP	ES:[DI],DL
	JNE	MDSXER		; JMP IF ERR
	ADD	DI,2
	LOOP	MDSX62
;
	OR	DL,DL
	JZ	MDSX64		; JMP IF ALL PATTERN END
	SUB	DL,55H		; FF --> AA --> 55 --> 00
	JMP	SHORT	MDSX61
;
MDSX64:
	XOR	DI,DI
	MOV	CX,1000H
	MOV	AL,20H
	REP	STOSW
	MOV	CX,1000H
	MOV	AL,0E0H
	REP	STOSW
;
;   GRAPH VRAM R/W TEST
	MOV	DX,0FFFFH	; INLZ TEST PATTERN
MDSX70:	CALL	MDS60W
	CALL	MDS60R
	JNE	MDSXER		; JMP IF ERR
;
	OR	DX,DX
	JZ	MDH00		; JMP IF ALL PATTERN END
	SUB	DX,5555H	; FF --> AA --> 55 --> 00
	JMP	SHORT	MDSX70
;
;   VRAM R/W TEST ERROR PROCESS
MDSXER:	MOV	BX,0102H
	CALL	MDPSD		; BEEP OUT TO LOCATE FAULT
;
	MOV	AX,0A000H
	MOV	ES,AX
	XOR	DI,DI
	MOV	CX,1000H
	MOV	AL,20H
	REP	STOSW
	MOV	CX,1000H
	MOV	AL,0E0H
	REP	STOSW
;
	XOR	DX,DX
	CALL	MDS60W		; GRAPH VRAM INLZ
MDH00:
	PAGE
;****************************************
;*					*
;*   NON VOLATILE MEMORY INITIALIZE	*
;*					*
;****************************************
;
;***** CHECK SW5
;
MDJ00:	IN	AL,PORTA
	TEST	AL,10H
	JZ	MDJ50		;JMP IF SW5=ON (NOT INLZ NVMW)
;
;***** SW5=OFF , INITIALIZE NON VOLATILE MEMORY
;
MDJ01:	MOV	AL,0DH
	OUT	68H,AL		;NVMW:=1 (WRITE PERMIT)
	MOV	AX,0A000H
	MOV	ES,AX
	MOV	BX,3FE2H
	MOV	ES:BYTE PTR [BX],48H ;(A3FE2):=48H
	MOV	BX,3FE6H
	MOV	ES:BYTE PTR [BX],05;(A3FE6):=05
	MOV	CX,5
MDJ02:	ADD	BX,4
	MOV	ES:BYTE PTR [BX],00;CLEAR NON VOLATILE MEM 6 BYTES
	LOOP	MDJ02
	MOV	AL,0CH
	OUT	68H,AL		;NVMW:=0 (WRITE INHIBIT)
PAGE
;****************************************
;*					*
;*	EXTENDED MEMORY TEST		*
;*	     AND INITIALIZE		*
;*					*
;****************************************
;   GET MM SIZE FROM NON VOLATILE MEMORY, AND CHECK WARM START OR NOT
MDJ50:
	TEST	BYTE PTR BIOS_FLAG+1,40H
	JNZ	MDJ51		;JUMP IF AWS
	MOV	AX,0A000H
	MOV	ES,AX
	MOV	BX,3FEAH
	MOV	DL,ES:[BX]	;DL:=(A3FEA)
	AND	DL,07H		;DL:=MM SIZE/128KB
	TEST	BYTE PTR BIOS_FLAG,80H	;CHECK WARM BIT
	JZ	MDJ60		;JMP IF COLD START
;
;---------------- 03-20-1984 (CHANGED) ----------------------
;	JMP	SHORT	MDJ55
;-------------------------- 04-23-1984 (CHANGED) ------------
	JMP	MDJ62		; WARM, SKIP CHECKING.
				; (DO AUTO MEMORY SIZING !)
;------------------------------------- 04-23-1984 -----------
;--------------------------- 03-20-1984 (CHANGED TO HERE) ------
;
MDJ51:
	MOV	DL,04H		;MM SIZE 640KB
	TEST	BYTE PTR BIOS_FLAG,80H
	JZ	MDJ60		;JUMP IF COLD START
	MOV	DL,BYTE PTR BIOS_FLAG+1
	AND	DL,0F8H
;
;***** WRITE MM SIZE IN BIOS_FLAG
;
MDJ55:	MOV	AX,BIOS_FLAG
	AND	AH,0F8H
	OR	AH,DL
	MOV	BIOS_FLAG,AX
	JMP	MDV00
;
;***** COLD START , CHECK EXTENDED MEMORY
;
;---------------- 03-20-1984 (CHANGED) -----------------
;
;MDJ60:	OR	DL,DL
;
MDJ60:	MOV	DL,04H		; SET MAX LIMIT (640KB)
	OR	DL,DL		; FOR AUTO MEMORY SIZING.
;--------------------- 03-20-1984 (CHANGED TO HERE) -------------
;
	JZ	MDJ55		;JUMP IF NO EXTENDED MEMORY
	MOV	DH,DL
	MOV	BX,2000H	;BX:=SEGMENT ADDRESS OF EXTENDED MM
	CLD
MDJ61:	PUSH	DX
	MOV	AL,08H
	OUT	SYS_PORT,AL	;MCKEN:=0
	XOR	AX,AX
	CALL	MDJWT		;WRITE ALL0 TO 128KB
	CALL	MDJWT		;WRITE ALL0 TO 128KB
	MOV	AL,09H
	OUT	SYS_PORT,AL	;MCKEN:=1
;
;***** START EXTENDED MM TEST
;
	MOV	AX,0FFFFH
	CALL	MDJRW		;ALL1 TEST
	JNZ	MDJER
	MOV	AX,0AAAAH
	CALL	MDJRW		;AAAA TEST
	JNZ	MDJER
	MOV	AX,5757H
	CALL	MDJRW		;5757 TEST
	JNZ	MDJER
	XOR	AX,AX
	CALL	MDJRW		;ALL0 TEST
	JNZ	MDJER
;
	POP	DX
	DEC	DH
	JZ	MDJ55
	ADD	BX,2000H
	JMP	SHORT	MDJ61		;JUMP TO CHECK NEXT 128KB
;
;---------------------------------------- 04-23-1984 (ADDED) --------
;
;	AUTO MEMORY SIZING PROCEDURE
;
MDJ62:
	XOR	CX,CX		; SEGMENT = 0000H
	XOR	BX,BX		; OFFSET  = 0000H
MEMSCAN:
	CMP	CX,8000H	; POINTS LAST OF 640K ?
	JZ	SETEND		; YES, SET 640K
	ADD	CX,2000H	; POINT TOP OF NEXT 128K
	MOV	DS,CX		; SET SEGMENT ADDR.
	MOV	AL,[BX]		; GET 1 BYTE
	NOT	AL		; INVERT IT TO WRITE
	MOV	[BX],AL		; WRITE TO SEE IF MEMORY EXISTS
	CMP	AL,[BX]		; CAN WE WRITE ?
	NOT	AL		; GET ORIGINAL BYTE
	MOV	[BX],AL		; RECOVER THIS BYTE OF MEMORY
	JZ	MEMSCAN		; OK, WE CAN WRITE. SEE NEXT !
	SUB	CX,2000H	; GET ADDR. WHERE WE CAN WRITE
SETEND:
	MOV	DX,CX		; SAVE FOR SHIFT
	MOV	CL,13		; GET UPPER 3 BITS
	SHR	DX,CL		; FINALY, WE GOT 0 - 4 VALUE.
	XOR	AX,AX
	MOV	DS,AX		; RECOVER ADDRESSING FOR MEMORY ACCESS
	JMP	MDJ55		; GO TO COMMON PROCESS TO SET BIOS_FLAG
;--------------------------------------- 04-23-1984 -------------
;
;***** EXTENDED MEMORY ERROR HANDLING
;
MDJER:	MOV	CL,5
	SHR	BH,CL
	DEC	BH
	MOV	AX,BIOS_FLAG
	AND	AH,0F8H
	OR	AH,BH
	MOV	BIOS_FLAG,AX
	TEST	BYTE PTR BIOS_FLAG+1,40H
	JNZ	MDJER1		;JUMP IF AWS
;
;----------------- 03-20-1984 (DELETED) -------------------
;
;	MOV	BX,0201H	;2 LONG SOUND AND 1 SHORT SOUND
;	CALL	MDPSD
;---------------- 03-20-1984 (DELETED TO HERE) ---------------------
;
MDJER1:
	JMP	SHORT	MDV00
;********************************
;*   MDJRW INNER ROUTINE	*
;*     IN (AX):WRITE PATTERN	*
;*        (BX):SEGMENT VALUE	*
;*     OUT  ZF: ERR(0) NML(1)	*
;********************************
MDJRW:	CALL	MDJWT		;WRITE 128KB WITH (AX) PATTERN
	MOV	DX,BX
	MOV	SI,2		; INLZ LOOP CNT
MDJRW10:MOV	ES,DX
	XOR	DI,DI
	MOV	CX,8000H
REPE	SCASW 			;CHECK 64KB
	JNZ	MDJRW20		;JMP IF ERR
	ADD	DX,1000H
	DEC	SI
	JNZ	MDJRW10		;JMP TO CHECK NEXT 64KB
;
;***** CHECK PARITY ERROR
;
	IN	AL,PORTB
	TEST	AL,02H
	MOV	AL,AH
MDJRW20:RET
;
;***** WRITE 128KB FROM (BX) SEG TO (BX)+1000H SEG
MDJWT:	MOV	DX,BX
	MOV	SI,2
MDJWT10:MOV	ES,DX
	MOV	CX,8000H	;CX:=COUNT OF 32KW
	XOR	DI,DI
REP	STOSW			;WRITE PATTERN TO 64KB
	ADD	DX,1000H
	DEC	SI
	JNZ	MDJWT10		;WRITE NEXT 64KB
	RET
PAGE
;****************************************
;*					*
;*	END OF ITF			*
;*					*
;****************************************
MDV00:	MOV	AL,09H
	OUT	SYS_PORT,AL	; MCK ENABLE F/F SET
	OUT	52H,AL		; ENABLE NMI INT
;
	JMP	ROM_INIT	; GO TO INITIALIZATION FOR ROM
PAGE
;****************************************************************
;*								*
;*   GDC COMMAND SET SUBROUTINE 				*
;*	ENTRY MDS00						*
;*	IN  (AH):BIT7 MASTER GDC(0)/SLAVE GDC(1)		*
;*		 BIT6 IF ON, NOT WAIT FIFO EMPTY AT CMD SET	*
;*		 BIT5 IF ON, CAN'T USE STACK OPERATION		*
;*	    	 BIT4-0 RFU					*
;*	    (BX):     CMD,PRM LIST HEAD ADRS			*
;*	    (SP):     RET ADRS IF AH:BIT5 ON			*
;*								*
;****************************************************************
MDS00:	TEST	AH,20H
	JNZ	MDS01		; JMP IF CAN'T USE STACK OP
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
;   SET PORT# TO DX
MDS01:	MOV	DX,GDC_M_CMD
	TEST	AH,80H
	JZ	MDS02		; JMP IF MASTER
	MOV	DX,GDC_S_CMD
;   WAIT FIFO EMPTY
MDS02:	TEST	AH,40H
	JNZ	MDS03		; JMP IF NOT WAIT FIFO EMPTY
	MOV	BP,OFFSET MDS03
	JMP	SHORT	MDS08
;   GET CMD,PRM LIST LENGTH
MDS03:	MOV	CL,CS:[BX]
	INC	BX
	XOR	CH,CH		; INLZ FIFO CNT
;   SET CMD CODE TO GDC(7220)
	MOV	AL,CS:[BX]	; GET CMD
	INC	BX
	INC	CH		; FIFO CNT UP
	DEC	CL
	OUT	DX,AL		; SET CMD
	SUB	DX,2		; PORT# CHNG (CMD --> PRM)
;   SET PRM CODE TO GDC (7220)
MDS04:	OR	CL,CL
	JZ	MDS06		; JMP IF PRM SET END
	CMP	CH,16
	JL	MDS05		; JMP IF FIFO NOT FULL
	XOR	CH,CH
	MOV	BP,OFFSET MDS05
	JMP	SHORT	MDS08		; WAIT FIFO EMPTY
MDS05:	MOV	AL,CS:[BX]
	INC	BX
	INC	CH		; FIFO CNT UP
	DEC	CL
	OUT	DX,AL		; SET PRM
	JMP	SHORT	MDS04
;   RET TO CALLER
MDS06:	TEST	AH,20H
	JNZ	MDS07		; JMP IF CAN'T USE STACK
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
MDS07:	JMP	SP		; RET TO CALLER
;
;   WAIT FIFO EMPTY INNER ROUTINE
MDS08:	TEST	AH,80H
	JNZ	MDS09		; JMP IF SLAVE
MDS081:	IN	AL,GDC_M_STA
	TEST	AL,GDC_EMPTY
	JZ	MDS081
	JMP	BP		; RETURN
MDS09:	IN	AL,GDC_S_STA
	TEST	AL,GDC_EMPTY
	JZ	MDS09
	JMP	BP		; RETURN
	PAGE
;****************************************************************
;*								*
;*   GRAPH VRAM (196KB) R/W SUBROUTINE				*
;*	ENTRY MDS60W: WRITE 196KB WITH (DX) PATTERN		*
;*	      MDS60R: READ 196KB, COMPARE WITH (DX),		*
;*		      AND SET ZF				*
;*	IN  (DX): PATTERN					*
;*	OUT   ZF: NML(1) ERR(0)					*
;*								*
;****************************************************************
MDS60W:	MOV	BP,0		; INDICATE WRITE ENTRY
	JMP	SHORT	MDS61
MDS60R:	MOV	BP,1		; INDICATE READ ENTRY
MDS61:	CLD
	MOV	SI,2		; LOOP CNT
	MOV	AL,0
	OUT	0A6H,AL		; PLANE 10,20,30 ACCESS
MDS62:	MOV	BX,0A000H
	MOV	ES,BX
	MOV	DI,8000H
	MOV	CX,4000H
	MOV	AX,DX		; PATTERN SET TO AX
	CMP	BP,0
	JE	MDS63		; JMP IF WRITE
REPE	SCASW	
	JNE	MDS67		; RTN IF ERR
	JMP	SHORT	MDS64
MDS63:
REP	STOSW		
MDS64:
	TEST	BYTE PTR BIOS_FLAG+1,08H
	JZ	MDS66			;JMP IF NO OPTION
	MOV	BX,0B000H
	MOV	ES,BX
	XOR	DI,DI
	MOV	CX,8000H
	MOV	AX,DX		; PATTERN SET TO AX
	CMP	BP,0
	JE	MDS65
REPE	SCASW	
	JNE	MDS67		; RTN IF ERR
	JMP	SHORT	MDS66
MDS65:
REP	STOSW		
MDS66:	DEC	SI
	JZ	MDS67
;
	MOV	AL,1
	OUT	0A6H,AL		; PLANE 11,21,31 ACCESS
	JMP	SHORT	MDS62
;
MDS67:	MOV	AL,0
	OUT	0A6H,AL		; SET TO ACCESS PLANE 10,20,30
	RET
PAGE
;****************************************
;*   BEEP OUT SUBROUTINE		*
;*	ENTRY MDPSD			*
;*	IN  (BH): CNT OF LONG BEEP	*
;*	    (BL): CNT OF SHORT BEEP	*
;*					*
;****************************************
MDPSD:	PUSHF
	CLI
	PUSH	AX
	PUSH	CX
	PUSH	DX
	OR	BH,BH
	JZ	MDP10
;
;***** LONG SOUND
;
MDP01:	MOV	DL,8		;SET TIME (2 SEC)
	CALL	MDP50
	DEC	BH
	JNZ	MDP01
;
;***** SHORT SOUND
;
MDP10:	OR	BL,BL
	JZ	MDP20
MDP11:	MOV	DL,1		;SET TIME (0.3 SEC)
	CALL	MDP50		;SPEAKER SET AND RESET
	DEC	BL
	JNZ	MDP11
;
;***** RETURN
;
MDP20:	POP	DX
	POP	CX
	POP	AX
	POPF
	RET
;
;***** BEEP ON WHILE (DL) TIMES AND BEEP OFF
MDP50:	XOR	CX,CX
	MOV	AL,06H
	OUT	SYS_PORT,AL	;SET SPEAKER
MDP51:	LOOP	MDP51
	DEC	DL
	JNZ	MDP51
	MOV	AL,07H
	OUT	SYS_PORT,AL	;RESET SPEAKER
MDP52:	LOOP	MDP52		;WAIT 0.5 SEC
MDP53:	LOOP	MDP53
	RET
PAGE
;****************************************
;*					*
;*	NMI INTERRUPT PROCESS		*
;*					*
;****************************************
MDF00:	PUSH	AX
	IN	AL,PORTB
	TEST	AL,02H
	JNZ	MDF01		; JMP IF EMCK=1
	POP	AX
	IRET
MDFMX	DB	'MEMORY ERROR'
;
MDF01:	MOV	SI,OFFSET MDFMX
	MOV	AX,0A000H
	MOV	ES,AX
	MOV	AX,SEG MDFMX
	MOV	DS,AX
	XOR	DI,DI
	MOV	CX,LENGTH MDFMX
	CLD
MDF02:	MOVSB	
	DEC	DI
	ADD	DI,2000H
	MOV	ES:BYTE PTR [DI],43H ; SET ATR(RED,BLINKING)
	SUB	DI,2000H
	ADD	DI,2
	IN	AL,PORTA
	TEST	AL,04H
	JZ	MDF03		; JMP IF 80 CHAR/LINE
	ADD	DI,2
MDF03:	LOOP	MDF02
	CLI
	HLT
PAGE
;****************************************
;*					*
;*	DEFAULT INT PROCESS		*
;*					*
;****************************************
;
;   ENTRY FOR INNER INT
MDXI0:	IRET
;
;   ENTRY FOR EXTERNAL INT
MDXI1:	PUSH	AX
	MOV	AL,0BH
	OUT	INTM_O3,AL
	NOP
	IN	AL,INTM_IS
	TEST	AL,80H
	JNZ	MDXI3		; JMP IF SLAVE INT
;
MDXI2:	MOV	AL,EOI
	OUT	INTM_O2,AL
	POP	AX
	IRET
;
MDXI3:	MOV	AL,EOI
	OUT	INTS_O2,AL
	MOV	AL,0BH
	OUT	INTS_O3,AL
	NOP
	IN	AL,INTS_IS
	OR	AL,AL
	JZ	MDXI2
	POP	AX
	IRET
PAGE
;****************************************
;*					*
;*	CMD,PRM LIST FOR GDC(7220)	*
;*					*
;****************************************
GDCM_8X_RESET	DB	1,GDC_RESET
GDCM_8X_MASTER	DB	1,GDC_MASTER
GDCM_88_SYNC	DB	9,GDC_SYNC_NIDC,010H,04EH,007H,025H,007H,007H,090H,065H
;----------------------------------------------------------------02/10/1984----
;GDCM_80_SYNC	DB	9,GDC_SYNC_NIDC,010H,04EH,007H,025H,00DH,00FH,0C8H,094H
;----------------------------------------- 04-24-1984 (C) ---------
;GDCM_80_SYNC	DB	9,GDC_SYNC_NIDC,010H,04EH,067H,034H,00BH,020H,0C8H,06CH
GDCM_80_SYNC	DB	9,GDC_SYNC_NIDC,010H,04EH,067H,02CH,00DH,018H,0C8H,08CH
;------------------------------------------------------------------------------
GDCM_8X_PITCH	DB	2,GDC_PITCH,050H
GDCM_8X_ZOOM	DB	2,GDC_ZOOM,000H
GDCM_8X_SCROLL	DB	17,GDC_SCROLL,000H,000H,0F0H,01FH,000H,000H,010H,000H,000H
		DB	000H,010H,000H,000H,000H,010H,000H
GDCM_88_CSR	DB	4,GDC_CSFORM,00FH,00H,7BH
GDCM_80_CSR	DB	4,GDC_CSFORM,007H,00H,3BH
GDCS_8X_RESET	DB	1,GDC_RESET
GDCS_8X_SLAVE	DB	1,GDC_SLAVE
GDCS_88_SYNC	DB	9,GDC_SYNC_NIDC,016H,026H,003H,011H,003H,007H,090H,065H
;----------------------------------------------------------------02/10/1984----
;GDCS_80_SYNC	DB	9,GDC_SYNC_NIDC,016H,026H,003H,011H,006H,00FH,0C8H,094H
;----------------------------------------- 04-24-1984 (C) ----------
;GDCS_80_SYNC	DB	9,GDC_SYNC_NIDC,016H,026H,063H,018H,005H,020H,0C8H,06CH
GDCS_80_SYNC	DB	9,GDC_SYNC_NIDC,016H,026H,063H,014H,006H,018H,0C8H,08CH
;------------------------------------------------------------------------------
GDCS_88_CSR	DB	2,GDC_CSFORM,001H
GDCS_80_CSR	DB	2,GDC_CSFORM,000H
GDCS_8X_PITCH	DB	2,GDC_PITCH,028H
GDCS_8X_ZOOM	DB	2,GDC_ZOOM,000H
GDCS_8X_SCROLL	DB	17,GDC_SCROLL,000H,000H,0F0H,01FH,000H,000H,010H,000H,000H
		DB	000H,010H,000H,000H,000H,010H,000H
GDCS_8X_TEXTW	DB	9,GDC_TEXTW,000H,000H,000H,000H,000H,000H,000H,000H
GDCS_8X_CODEW	DB	1,GDC_WRITE
PAGE
;
ROM	ENDS
;----------------------------------------------------------
;
;	POWER ON/RESET VECTOR --- FFFF:0000
;
;----------------------------------------------------------
RESET	SEGMENT	AT	0FFFFH
	ASSUME	CS:ROM,DS:NOTHING,SS:NOTHING,ES:NOTHING
	JMP	MDA00
RESET	ENDS
	END

