	PAGE 58,132
	TITLE		'BOOTROM'
;---------------------------------------------------------------------
; HISTORY :
;	11-18-1983	DELETE EXCESSIVE INIT. OF SYSCOM AREA.
;			DELETE SLAVE PIC MASK OFF PROC.
;	11-23-1983	ADD RETRY PROC. WHEN BOOTING FAILED
;	11-28-1983	BUG FIX. (INCORRECT RETRY PROC.)
;	04-26-1984	CHANGE BOOT STRUP.
;--------------------------------------------------------------------




;************************************************
;*						*
;*	EQUATE TABLE				*
;*						*
;************************************************
;
;*	I/O PORT
;
CMOS_ENABLE	EQU	0DH	; CMOS WRITE ENABLE CODE
CMOS_DISABLE	EQU	0CH	; CMOS WRITE DISABLE CODE
CMOS_PROTECT	EQU	68H	; CMOS PROTECT PORT

	INCLUDE	B:EQCOM.LIB
;************************************************
;*						*
;*	EXTRNAL/PUBLICS				*
;*						*
;************************************************
;
	EXTRN	DS_INIT0:NEAR	; FD/HD INITIALIZE STAGE 0
	EXTRN	DS_INIT1:NEAR	; FD/HD INITIALIZE STAGE 1
	EXTRN	DS_BOOT:NEAR	; FD/HD BOOT LOADER
;
	PUBLIC	BOOT_START	; ENTRY TO START BOOT PROCEDURE
				; (JMPED FROM ITFROM, WHEN ITF 
				;  PROCEDURES ARE FINISHED.)
	PAGE
;************************************************
;*						*
;*	DATA SEGMENT (MUST BE IN RAM)		*
;*						*
;************************************************
;
	INCLUDE B:SYSCOM.LIB

;****************************************
;*					*
;*	OTHOR SEGMENT			*
;*					*
;****************************************
CMOS	SEGMENT AT 0A000H
	ORG	3FF2H
MEM_SW5	LABEL	BYTE		; DEFAULT BOOT DRIVE
				;  BIT7 ON=HD,OFF=FD
				;  BIT5 ON=5"FD,OFF=8"FD
				;  BIT4 UNIT NUMBER OF HD
				; RENARKE
				;  0000B=STANDART
				;  0010B=5"FD
				;  1010B=5"HD UNIT0
				;  1011B=5"HD UNIT1
CMOS	ENDS
	PAGE
;****************************************************************
;*								*
;*	ROM LOADER PROGRAM MAIN ROUTINE				*
;*								*
;*	(1) INTIALIZE ROM DISK DRIVER AND CONNECT CHECK		*
;*		(a) 5"FD DRIVER (STAGE0 AND STAGE1)		*
;*		(b) FIXED DISK DRIVER (STAGE0)			*
;*		(c) OPTION DRIVER AT EXTENDED ROM		*
;*		    (STAGE0, STAGE1, ENTRY)			*
;*	(2) REPEAT LOAD BOOT SECTOR AND RUN.			*
;*		(a) CHECK EXTENDED ROM DRIVER			*
;*		(b) IF STANDERT, CHECK 5"FD, 5"HD UNIT 0 AND 1	*
;*		    IF 5"FD, CHECK 5"FD UNIT 0 AND 1		*
;*		    IF 5"HD, CHECK 5"HD UNIT 0 OR  1		*
;*								*
;****************************************************************
;****************************************
;*	CODE SEGMENT			*
;****************************************

ROM	SEGMENT	WORD	PUBLIC
	ASSUME	CS:ROM,DS:SYSCOM,ES:CMOS,SS:SYSCOM
;-----------------------------------------------
;
;*	INTIALIZE DISK DRIVER
;
;				10-26-1983
;-----------------------------------------------

BOOT_START	LABEL	NEAR		; BOOT PROCEDURE STATUS FROM HEAR

;-----------------------------------------------DELETED 11-18-1983-----
;
;	INITIALIZE EXTENDED ROM DRIVER
;
	XOR	AX,AX
	MOV	DS,AX			; CLEAR DS REGISTER
;------------------------------------------------DELETE 11-18-1983---
	CALL	INIT0_ENTRY		; INITIALIZE OPTION DISK DRIVER (STAGE0)
	CALL	DS_INIT0                ; INITIALIZE PERIPHERAL FD/HD DRIVER (STAGE0)
	CALL	INIT1_ENTRY		; INITIALIZE OPTION DISK DRIVER (STAGE1)
	CALL	DS_INIT1                ; INITIALIZE PERIPHERAL FD/HD DRIVER (STAGE1)

	CALL	EXT_ENTRY		; CALL EXTEND ROM DRIVER

BOOT:
	CALL	BOOT_ENTRY		; CALL ROM LOADER
;------------------------------------------------ 11-23-1983 (C)-----
BOOT_RETRY:
	MOV	AX,0F00H		; MEANS RETRY FROM START -- 11-28-1981 (C)
	CALL	BOOT_ENTRY10		; GO TO RETRY
	JMP	BOOT_RETRY		; FAILED, RETRY FOREVER
	PAGE
;********************************************************
;*							*
;*	INITALIZE AND BOOT SUBROUINES			*
;*							*
;*	REMARK						*
;*		STRUCTURE OF EXTENDED ROM DRIVER	*
;*							*
;*		NUMBER : NAX 8				*
;*		ADDRESS : FROM F000:0 TO F7FF:F		*
;*			 AND 1000H BOUNDARY		*
;*		ENTRY POINT : FX00:Y			*
;*				X = 0..7		*
;*				IF Y=0C, INYTIALIZE 0	*
;*				IF Y=0F, INITIALIZE 1	*
;*				IF Y=12, COMMAND PROCESS*
;*				IF Y=15, BOOT PROCESS	*
;*							*
;********************************************************
;---------------------------------------------- 11-23-1983 (C) -----
;************************************************
;*						*
;*	EXTENDED ROM INITALIZE PHASE-0		*
;*		CALL FX00:0C	X=0..7		*
;************************************************
INIT0_ENTRY:
	MOV	XROM_OFFSET,INIT0_OFFSET; SET INIT0 ENTRY OFFSET
	CALL	SUB_SET			; SET INIT0 ENTRY SEGMENT
INIT0_ENTRY10:
	MOV	ES,XROM_SEGMENT		; GET EXTENDED ROM SEGMENT ADDR
	CMP	ES:WORD PTR [9H],0AA55H	; CHECK EXISTANCE OF ROM
	JNZ	INIT0_ENTRY20		; SKIP IF NOT
	CMP	ES:WORD PTR [9H],0AA55H	; SAME DO 
	JNZ	INIT0_ENTRY20		

	MOV	AL,[BX]			; GET ID_TABLE VALUE
	OR	AL,AL			; CHECK IT
	JNZ	INIT0_ENTRY20		; SKIP IF THIS ROM HAS NO TABLE

	PUSH	ES
	CALL	SUB_XROM		; CALL EXTENDED ROM
	POP	ES
INIT0_ENTRY20:
	INC	BX			; INCREMENT TABLE ADDR
	ADD	XROM_SEGMENT,100H       ; SET NEXT ROM SEGMENT ADDR
	LOOP	INIT0_ENTRY10		; DO LOOP
	RET
;************************************************
;*						*
;*	EXTENDED ROM INITALIZE PHASE-1		*
;*		CALL	FX00:0F	X=0..7		*
;************************************************
INIT1_ENTRY:
	MOV	XROM_OFFSET,INIT1_OFFSET
	JMP	SHORT	COMMON_ENTRY
;************************************************
;*						*
;*	EXTENDED ROM EXTENT PHASE		*
;*		CALL	FX00:12	X=0..7		*
;************************************************
EXT_ENTRY:
	MOV	XROM_OFFSET,EXT_OFFSET
;
;*	COMMON PROCESS
;
COMMON_ENTRY:
	CALL	SUB_SET			; SET EXTEND ROM SEGMENT
COMMON_ENTRY10:
	TEST	BYTE PTR [BX],40H	; CHECK EXISTANCE OF ROM
	JZ	COMMON_ENTRY20		; SKIP IF NO TABLE
	CALL	SUB_XROM		; CALL EXTENDED ROM
COMMON_ENTRY20:
	INC	BX			; INCREMENT ID_TABLE ADDR
	ADD	XROM_SEGMENT,100H       ; SET NEXT ROM SEGMENT ADDR
	LOOP	COMMON_ENTRY10		; DO LOOP
	RET
	PAGE
;************************************************
;*						*
;*	LOAD BOOT SECTOR BY 5"FD/5"HD DRIVER	*
;*	OR EXTENDED ROM DRIVER.			*
;*						*
;*		CALL	FX00:15	X=0..7		*
;************************************************
BOOT_ENTRY:
;--------------------------------------------------INSERT APR/26/84----
;
;*	CHECK "PF" AND "FNC" KEY AND MARGE CMOS
;
	MOV	AX,CMOS
	MOV	ES,AX			; ES=CMOS SEGMENT
	MOV	AH,[MEM_SW5]		; AH=BOOT DEVICE AT MEMORY SWITCH
	MOV	AL,[SYS_SEL]		;
	CMP	AL,0			; KEY NONE ?
	JZ	BOOT_ENTRY06		; Y
	AND	AH,01FH			; SET 5"HD
	OR	AH,0A0H			;
	CMP	AL,13			; PF KEY ?
	JC	BOOT_ENTRY05		; Y
	AND	AH,01FH			;
	OR	AH,020H			;
	CMP	AL,80H			; FNC KEY ?
	JNZ	BOOT_ENTRY06		; N
BOOT_ENTRY05:
	MOV	AL,CMOS_ENABLE
	OUT	CMOS_PROTECT,AL		; CMOS WRITE ENABLE
	MOV	[MEM_SW5],AH		; CHANGE CMOS
	MOV	AL,CMOS_DISABLE		; CMOS WRITE DISABLE
	OUT	CMOS_PROTECT,AL	;
BOOT_ENTRY06:

	MOV	AH,[MEM_SW5]		; GET BOOT DEVICE
;----------------------------------------------------------------------
;
;	REPEAT LOAD BOOT SECTOR
;		IF STADERT, CHECK ALL DEVICE (FROM 01 TO 0F)
;		IF 5"FD, CHECK FD DEVICE (FROM 02 TO 02)
;		IF 5"HD, CHECK HD DEVICE (FROM 0A TO 0A OR FROM 0B TO 0B)
;
	MOV	AL,1			; AL=END DEVICE CODE (1..F)
	AND	AH,0F0H			; AH=CURRENT DEVICE CODE
	JZ	BOOT_ENTRY10		; STANDERT ?
	MOV	CL,4
	ROR	AH,CL			; AH=CURRENT DEVICE CODE
	MOV	AL,AH			; AL=END DEVICE CODE
BOOT_ENTRY10:
;
;*	LOAD BOOT SECTOR BY EXTENDED ROM DRIVER
;
	MOV	XROM_OFFSET,BOOT_OFFSET	
	CALL	SUB_SET
BOOT_ENTRY20:
	TEST	BYTE PTR [BX],40H	; CHECK INSTALL OF ROM
	JZ	BOOT_ENTRY30		; SKIP IF NO
	CALL	SUB_XROM		
BOOT_ENTRY30:
	INC	BX			; INCREMENT ID_TABLE ADDR
	ADD	XROM_SEGMENT,100H	; SET NEXT ROM ADDR
	LOOP	BOOT_ENTRY20
;
;*	LOAD BOOT SECTOR PERIPHERAL DEVICE
;
	CALL	SUB_MROM		; BOOT FROM MAIN ROM
LAST_CHECK:
	CMP	AH,AL			; DEVICE END ?
	JNZ	LAST_CHECK10		; NO,
LAST_EXIT:
 	RET				                  
LAST_CHECK10:
	CMP	AL,15			; END DEVICE CODE ?
	JAE	LAST_EXIT		; YES
	INC	AL			; CHANGE DEVICE CODE
	JMP	SHORT	BOOT_ENTRY10	; RETRY LOAD BOOT SECTOR
	PAGE
;************************************************
;*						*
;*	SMALL SUBROUTINE			*
;*						*
;************************************************

;****************************************
;*	BOOT FROM STANDERT ROM		*
;****************************************
SUB_MROM:
	PUSH	AX
	CALL	DS_BOOT
	POP	AX
	RET
;****************************************
;*	BOOT FROM EXTENDED ROM		*
;****************************************
SUB_XROM:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	CALL	DWORD PTR XROM_PTR
	POP	CX
	POP	BX
	POP	AX
	RET
;****************************************
;*	READY TO CALL EXTENDED ROM	*
;****************************************
SUB_SET:
	MOV	BX,O                                                                                   