		PAGE	58,132
		TITLE	IPL_HD
;****************************************************************
;*
;*	IPL_HD
;*
;****************************************************************

DSKIO		EQU	1DH

IPL		SEGMENT	WORD PUBLIC 'CODE'
		ASSUME	CS:IPL

IPL_HD		PROC	FAR
;
;		JMP	NEAR PTR IPL_START
;
		DB	0E9H
		DW	(OFFSET IPL_START) - ($+2)
;
		DB	'NEC 2.00'
;
;	BPB
;
		DW	512
		DB	16
		DW	1
		DB	2
		DW	272
		DW	0		; OVERWRITE BY INIT
		DB	0F8H
		DW	8
		DW	17
		DW	0
		DW	0
;
;	SYSTEM FILE NAME
;
IOSYS_NAM	DB	'IO      SYS'
MSDOSSYS_NAM	DB	'MSDOS   SYS'
;
;	WORK AREA
;
RTRY_IPL	DB	0
SS_IPL		DW	0
SP_IPL		DW	0
AX_IPL		DW	0

IPL_START:
;
;	SAVE REGISTER
;
		MOV	CS:SS_IPL,SS
		MOV	CS:SP_IPL,SP
		MOV	CS:AX_IPL,AX
		MOV	AX,CS
		MOV	SS,AX
		MOV	SP,512
		PUSH	CS:AX_IPL
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		PUSH	BP
		PUSH	DS
		PUSH	ES
		MOV	DS,AX		; CS,DS,SS = CS
		XOR	AX,AX		; ES = 0
		MOV	ES,AX		;

		ASSUME	DS:IPL,SS:IPL,ES:SYS

;
;	SEARCH SYSTEM FILE
;
		PUSH	CX
		PUSH	DX
		ADD	CX,17		; DIRECTORY AREA
		ADC	DX,0
		MOV	BX,512
		MOV	BP,OFFSET BUF
		CALL	READ_HD
		JC	RETURN1
		MOV	DI,OFFSET BUF
		MOV	SI,OFFSET IOSYS_NAM
		CMP	BYTE PTR ES:[DI+11],08H	; VOL LABEL ?
		JNE	NOT_VOL1
		ADD	DI,32
NOT_VOL1:
		MOV	CX,11
		CLD
		REPE	CMPSB		; 'IO.SYS' ?
		JNE	RETURN1
		ADD	DI,32-11
		MOV	SI,OFFSET MSDOSSYS_NAM
		MOV	CX,11
		REPE	CMPSB		; 'MSDOS.SYS' ?
		JNE	RETURN1
;
;	LOAD SYSTEM
;
		POP	DX
		POP	CX
		ADD	CX,34
		ADC	DX,0
		MOV	BX,1024*62
		MOV	BP,OFFSET BUF
		CALL	READ_HD
		JC	RETURN
;
;	JUMP SYSTEM
;
		MOV	AX,60H		; JUMP 0060:0000
		PUSH	AX
		XOR	AX,AX
		PUSH	AX
		RET
;
;	ERROR RETURN
;
RETURN1:
		POP	DX
		POP	CX
RETURN:
		POP	ES
		POP	DS
		POP	BP
		POP	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		MOV	SS,CS:SS_IPL
		MOV	SP,CS:SP_IPL
		RET
IPL_HD		ENDP

;
;	READ ROUTINE
;
READ_HD		PROC
		MOV	AL,ES:DISK_BOOT
		OR	AL,10000000B
		MOV	DS:RTRY_IPL,3
READ_HD1:
		MOV	AH,0D6H		; READ COMMAND
		INT	DSKIO
		JNC	READ_HD_OK
		DEC	DS:RTRY_IPL
		JZ	READ_HD_ERROR
		MOV	AH,0D7H		; RECALIBRATE COMMAND
		INT	DSKIO
		JMP	SHORT READ_HD1
READ_HD_ERROR:
		STC
READ_HD_OK:
		RET
READ_HD		ENDP

		ORG	512 - 4
		DB	0
		DB	0
		DW	55AAH		; IPL ID

IPL		ENDS

;
;	DUMMY DATA SEGMENT
;
SYS		SEGMENT	AT 0
		ORG	402H
DISK_BOOT	DB	?
		ORG	600H
BUF		LABEL	FAR
SYS		ENDS

		END
