;
;** SAMPLE PROGRAM **
;
;************************************
;DOWN LOADER AND PROM WRITER
;************************************
;
;THIS ROUTINE READS .OBJ FILE FROM DISK
;AND CONVERT ASCII TO BINARY.(STORE INTO ROM-WRITING BUFFER (1800H~27FFH).)
;
;** THE PROM WRITING SUBROUTINE, USRHI & USRLO ARE PECULIAR TO MY SYSTEM.
;SO, PLEASE RE-WRITE TO YOUR SYSTEM.
;
;
;
;
;******* DOCUMENT OF THE ROMWR ********
;
;
;THE METHOD FOR USAGE IS AS FOLLOWS.
;
;(CR IS RETURN.)
;
;ON CP/M	TYPE AS FOLLOWS.
;
;	ROMWR <CR>
;
;(DOES NOT NEED ANY .OBJ FILE NAME.)
;
;THEN THE ROMWR.COM WILL BE EXECUTED.
;
;
;IN ROMWR	TYPE AS FOLLOWS.
;
;FIRST TYPE YOUR .OBJ FILE NAME.
;
;FOR EXAMPLE,	BASIC <CR>
;THIS MEANS BASIC.OBJ IS READ FROM DISK.
;(NO NEED .OBJ EXTENSION CHARACTER.)
;
;THE DRIVE NAME IS AVAILABLE.
;
;EX.	B:BASIC <CR>
;	MEANS BASIC.OBJ IN DRIVE B.
;
;IF THIS NAME IS CORRECT, TYPE 'Y'.
;
;
;IF ROMWR ASK THE START ADDRESS TO YOU,
;TYPE START ADDRESS BY HEXA-DECIMAL.
;FROM THIS ADDRESS, ROMWR CONFIGURES THE TRANSLATED OBJECT INTO ROM-BUFFER.
;
;IF THE ADDRESS IN .OBJ FILE IS SKIPED,
;THEN THE MESSAGE 'SKIP AREA FROM ** TO **' IS OUTPUT.
;THE SKIPED AREA IN THE ROM-BUFFER IS FULLED BY 0FFH.
;(WHICH CAUSE NO CHANGE IN ROM WRITING.)
;IF THE SKIP AREA IS VERY LARGE (GREATER THAN 64K BYTES),
;THEN ROMWR EXECUTE NO WRITING, AND RESTART FROM THE FIRST.
;
;
;FOR EXAMPLE
;
;SUPPOSE THAT THE CONTENTS OF BASIC.OBJ ARE
;
;0000 0200    3456 7890 ABCD
;0000 0400    0011 2233
;
;
;AND SUPPOSE THAT YOU TYPED THE START ADDRESS 200,
;THEN THE MESSAGE
;'SKIP AREA FROM 0000_0206 TO 0000_0400'
;WILL BE TYPED OUT.
;AND THE CONTENTS OF ROM-BUFFER ARE AS FOLLOWS
;
;ADDRESS	DATA
;1800H		34 56 78 90 AB CD FF FF
;1810H		FF FF FF FF FF FF FF FF
;.....		.........
;1A00H		00 11 22 33 FF FF FF FF
;.....		.........
;27F0H		FF FF FF FF FF FF FF FF
;
;
;THE SUBROUTINE USRHI WRITE THE DATA IN THE ROM-BUFFER (1800H~27FFH)
;TO 2716.
;THE USRHI WRITE THE HIGHER BYTE ONLY.
;I.E.	WRITE 34,78,AB IN THE ABOVE EXAMPLE.
;THE SUBROUTINE USRLO WRITE THE LOWER.
;I.E.	56,90,CD ......
;
;
;
;IF YOU WISH TO TRANSFER THE BINARY 16-BIT WORD DOWN-LOADED BY ROMWR,
;(IN THE 68000-SYSTEM DEVELOPMENT,
;SOMETIMES THE DATA TRANSFER FROM CP/M MACINE TO TARGET SYSTEM
;WILL BE EMPLOIED.
;OR BY THE PROM, THE PROGRAMS ARE IMPLANTED TO TARGET MACINE.)
;PLEASE RE-WRITE THE SUBROUTINE USRHI,USRLO.
;
;
;THIS ROMWR CAN LINK OBJECT PROGRAMS.
;
;USE PIP IN CP/M ,AND MERGE SOME .OBJ FILES.
;(ALSO USAGE OF ED.COM IS AVAILABLE.)
;AND USE ROMWR.
;
;
;OR IN OTHER METHOD,
;
;USE ROMWR
;AND READ VALIOUS .OBJ FILES
;AND DOWN LOAD THEM STEP BY STEP.
;
;IF USRHI,USRLO DO NOT WRITE 0FFH AREA,
;THEN YOU CAN OVER-WRITE TO THE SAME PROM.
;
;
;EX.
;SUPPOSE THAT
;	BASIC.OBJ HAS ADDRESS FROM 0000 0200H TO 0000 0400H.
;	PASCAL.OBJ HAS ADDRESS FROM 0000 0500H TO 0000 0700H.
;
;THEN YOU CAN WRITE TWO .OBJ INTO SAME PROM.
;
;METHOD ARE
;
;FIRST DESIGNATE THE BASIC.OBJ IN ROMWR.
;WRITE IT TO PROM.
;SECOND DESIGNATE THE PASCAL.OBJ IN ROMWR.
;AND WRITE IT TO THE SAME PROM.
;
;(ATTENTION.... DO'NT CONFUSE THE HIGHER AND LOWER BYTE PROMS.)
;
;
;
;OTHER METHOD IS
;
;USE PIP AND TYPE
;PIP AAA.OBJ=BASIC.OBJ,PASCAL.OBJ
;(MERGE TWO FILES TO AAA.OBJ)
;DESIGNATE AAA.OBJ IN ROMWR
;
;
;IF YOU USE PIP, TAKE CARE THAT
;THE ADDRESS IN .OBJ FILE DOES NOT BECOME INVERSE ORDER.
;I.E.	ADDRESS		DATA
;	0000 0400	1234 5678 ....
;	0000 0410	......
;	........	.....
;	0000 06F0	....
;	0000 0200	.....
;	0000 0210	.....
;	.....		....
;
;THE 06FF TO 0200 IS INVERSE ORDER.
;
;IF THE ADDRESS ORDER IS INVERTED,THE ROMWR INTERPLET IT AS VERY LARGE SKIP.
;AND THE ERROR TERMINATE THE ROMWR.
;
;THE ERROR MESSAGE 'MINUS SKIP' WILL BE OUTPUT.
;
;
;
;
;FOR ADDITIONAL INFORMATION
;SEE SOURCE LIST.
;OR,
;PLEASE EXECUTE ROMWR, AND USE DDT, DUMP THE ROM-BUFFER (1800H TO 27FFH).
;
;
;
;
;******** DOCUMENTATION END *******
;
;
;
;PROM WRITER
;
;SYMBOL DEFINITION LIBRARY
;
	DEL3	EQU	0
	CR	EQU	0DH
	SPACE	EQU	20H
	TAB	EQU	9
	LF	EQU	0AH
	EOF	EQU	1AH
	BELL	EQU	7
;
;
;** USER SUBROUTINE ADDRESS DEFINITION **
;
;THIS ROUTINE WRITE 1800H~27FFH TO PROM (2716).
;
;
;DATA BUFFER AREA DEFINITION
;
CBASE	EQU	6	;CP/M TPA END ADDR.POINTER
;
;FDOS USE
;
;SYSTEM CALL COMMANDS
;
REBOOT	EQU	0	;CP/M RE-BOOT
BDOS	EQU	5
FCB	EQU	5CH	;FILE CONTROL BLOCK ADDR.
SETDMA	EQU	26
OPEN	EQU	15
READS	EQU	20	;SEQUENTIAL READ
WRITES	EQU	21	;SEQUENTIAL WRITE
CLOSE	EQU	16
MAKE	EQU	22
DELETE	EQU	19
LIST	EQU	5
CONIN	EQU	1
CONOUT	EQU	2
CONRD	EQU	10	;CONSOLE READ
;
;
;BUFFER AREA DEFINITION
;
ROMBUF	EQU	1800H
OBJBSZ	EQU	128*2*80	;OBJECT FILE SOURCE BUFFER SIZE
OBJBUF	EQU	3000H
OBJBLT	EQU	OBJBSZ-256	;SOURCE READ LIMIT
OBJBUF1	EQU	OBJBUF+256
;
;OBJBSZ-OBJBLT MUST BE 256.
;IF YOU WANT TO REWRITE THE DIFFERENCE (256 BYTES),
;YOU HAVE TO REWRITE RECONFIGURE BYTE COUNTS OF
;READSC PROCEDURE.
;
;** INITIAL SET & MAIN ROUTINE.
;
;
	ORG	100H
;
;** MAIN **
;
;
MAIN:	LXI	SP,STACK
	CALL	INIT	;INITIALIZE
	CALL	FNAME
	CALL	FOPEN
	LXI	H,MESS2
	CALL	ASK	;WRITING OK ?
	CPI	'Y'
	JZ	MAIN1
MAIN0:	CALL	CONTI	;ASK CONTINUE
	JZ	MAIN	;YES
	JMP	ALLEND
;
;
;SET START ADDRESS TO (ADDR)
;
MAIN1:	CALL	SETADR
;
;INITIAL ADDRESS SET
;
MAIN2:	LXI	B,ADDR
	LXI	H,ADDR1
	CALL	TRANS	;TRANFER 32-BIT ADDRESS
;(BC)>>(HL)
;
	LXI	B,ADDR
	LXI	H,ADDR3
	CALL	TRANS
;
	LXI	B,ADDR
	LXI	H,ADDR2
	CALL	ADRADD	;INCREMENT ADDRESS
;(BC)+1000H>>(HL)
;
	LXI	H,0
	SHLD	DCOUNT
	LXI	D,OBJBUF+OBJBSZ
;INITIAL VALUE OF SOURCE POINTER
;
MAIN3:	CALL	EXTRCT
;
;READ OBJECT SOURCE FROM DISK AND
;EXTRACT HEX DATA AND SET TO ROM BUFFER
;IF EXSIST ERROR,THEN CY=0
;SPTR,ADDR,DCOUNT ARE SET.
;
	JNC	MAIN0
	CALL	ROMWR	;ROM WRITE
;WRITE COUNT=(DCOUNT)
;
;REWRITE WRITE ADDRESS
;
	LXI	H,ADDR1
	LXI	B,ADDR2
	CALL	TRANS
	LXI	B,ADDR2
	LXI	H,ADDR2
	CALL	ADRADD
;
;TEST ALL OBJECT HAS WRITTEN ?
;
	LHLD	SPTR	;SOURCE POINTER
	MOV	A,M
	CPI	EOF
	JZ	MAIN5
	XCHG	;SET DE
	JMP	MAIN3
;
;TERMINATE ONE FILE WRITE
;
MAIN5:	CALL	FCLOSE
	CALL	CONTI
	JZ	MAIN
	JMP	ALLEND
;
;
;
;
;READ OBJECT SOURCE AND EXTRACT HEX DATA
;AND STORE INTO ROM BUFFER.
;
;
;INIT.
;
;SOURCE POINTER IS DE
;EXTRACT ADDRESS POINTER IS (ADDR).
;
;
;FINAL.
;
;NEW SOURCE POINTER IS (SPTR)
;NEW EXTRACT ADDRESS IS (ADDR3).
;DATA COUNT FOR WRITE IS (DCOUNT)
;
;IF HIT ERROR THEN CY=0
;
EXTRCT:	MVI	A,0FFHGET DATA ?
	JNZ	COM3
	CALL	TIMLAG
	IN	TSYSST
	CPI	5AH	;REALY ?
	JNZ	COM3
;
	MVI	A,0F6H	;TRANSFER END
	OUT	XFCONT
	RET
	CALL	READSC	;READ OBJ SOURCE
	XCHG
	SHLD	SPTR
	XCHG
	LDAX	D
	CPI	CR
	JNZ	EXTR2
	INX	D
	LDAX	D
	CPI	LF
	JNZ	ERROR
	INX	D
	JMP	EXTR1
;
EXTR2:	CPI	EOF
	JNZ	EXTR3
	STC
	RET
;
EXTR3:	LHLD	DCOUNT
	LXI	B,-(1000H)
	DAD	B
	JNC	EXTR4	;NOT FULL
;
;REACHED TO ROM BUFFER LIMIT
;
	XCHG
	SHLD	SPTR
	XCHG
	STC
	RET
;
EXTR4:	LXI	H,ADDR2
	LXI	B,ADDR3
	CALL	ADRCMP	;ADDRESS COMPARE
;32-BIT COMPARE (BC) TO (HL)
;(BC)-(HL)
;
	JC	EXTR5	;NOT EXCEEDED
;
;EXCEEDED ADDRESS LIMIT
;
	STC
	RET
;
EXTR5:	CALL	ADREXT	;ADDRESS EXTRACT
;IF HIT THEN CY=0
;AND SET ADDRESS TO ADDR3
;
	JC	EXTR6
	JMP	EXTR1
;
EXTR6:	LDAX	D
	CPI	SPACE
	JNZ	EXTR7
	CALL	SKPBLK
	JMP	EXTR1
;
;EXTRACT DATA
;
EXTR7:	CALL	EXTHEX	;EXTRACT HEX NUMBER
;IF HIT THEN CY=0, AND DATA IS IN HL
;DATA ORDER IS H=MSB,L=LSB.
;AND DATA COUNT IS IN B REGISTER.
;
	JC	ERROR
;
	PUSH	D
	XCHG
	MOV	A,B
	LHLD	DCOUNT
	PUSH	H
	POP	B
	LXI	H,ROMBUF
	DAD	B
	MOV	M,D
	INX	H
	INX	B
	DCR	A
	JZ	EXTR8
	MOV	M,E
	INX	B
EXTR8:	PUSH	B
	POP	H
	SHLD	DCOUNT
	INR	A
	MVI	B,0
	MOV	C,A
	LHLD	ADDR3
	DAD	B	;INCREMENT ADDRESS
	SHLD	ADDR3
	JNC	EXTR9
	LHLD	ADDR3+2
	INX	H
	SHLD	ADDR3+2
EXTR9:	POP	D
	JMP	EXTR1
;
;
;ERROR
;
ERROR:	PUSH	D
	LXI	H,MESS13
	CALL	MESSAGE
	LXI	D,SPTR+1
	LXI	H,LINBUF
	CALL	QHAT
	MVI	M,0
	CALL	MESSAGE
	CALL	CRLF
	POP	D
	JMP	MAIN
;
;
;EXTRACT ADDRESS PART
;
;IF HIT THEN CY=0
;AND SET ADDRESS TO ADDR3
;ELSE NOP
;
ADREXT:	CALL	HEXNUM	;HEX NUM TEST
	RC	;NOT HEX
;
	XCHG
	SHLD	SPTR2
	XCHG
	CALL	EXTHEX	;FIRST 16-BIT EXTRACT
	JNC	ADREX2
ADREX1:	LHLD	SPTR2	;ERROR
	XCHG
	STC
	RET
;
ADREX2:	DCR	B	;1-BYTE DATA ?
	JZ	ADREX1	;YES
	SHLD	NBUF3+2
;
;SKIP 1 SPACE
;
	LDAX	D
	CPI	SPACE
	JNZ	ADREX1
	INX	D
;
;EXTRACT NEXT 16-BIT
;
	CALL	EXTHEX
	JC	ADREX1
	DCR	B
	JZ	ADREX1
	SHLD	NBUF3
;
;NEXT 4 SPACE SKIP
;
	MVI	B,4
ADREX3:	LDAX	D
	CPI	SPACE
	JNZ	ADREX1
	INX	D
	DCR	B
	JNZ	ADREX3
;
;THIS DATA IS ADDRESS
;
;TEST SKIP SIZE
;
	LXI	H,ADDR3
	LXI	B,NBUF3
	CALL	ADRCMP	;32-BIT COMPARE
;(BC)-(HL)
	JNC	ADREX4	;(BC)>=(HL)
;
;MINUS ERROR
;
	LXI	H,MESS11
	CALL	MESSAGE
	JMP	MAIN0
;
ADREX4:	JZ	ADREX7	;(BC)=(HL)
;
;PRINT OUT SKIP MESSAGE
;
	LXI	H,MESS9
	CALL	MESSAGE
	LXI	H,ADDR3
	CALL	PRADR	;ADDRESS PRINT
	LXI	H,MESS10
	CALL	MESSAGE
	LXI	H,NBUF3
	CALL	PRADR
	CALL	CRLF
;
;SET NEW DCOUNT
;
	LXI	B,ADDR3
	LXI	H,NBUF1
	CALL	TRANS
	LXI	B,NBUF3
	LXI	H,NBUF2
	CALL	TRANS
	CALL	NSUB	;32-BIT SUBTRACT
;(NBUF2)-(NBUF1)>>(NBUF2)
;
	LHLD	NBUF2+2
	MOV	A,H
	ORA	L
	JZ	ADREX5
;
;VERY LARGE SKIP
;
ADREX6:	LXI	H,MESS12
	CALL	MESSAGE
	JMP	MAIN0
;
ADREX5:	LHLD	DCOUNT
	PUSH	H
	POP	B
	LHLD	NBUF2
	DAD	B
	JC	ADREX6
;
;SET NEW ADDR3
;
	SHLD	DCOUNT
	LXI	B,NBUF3
	LXI	H,ADDR3
	CALL	TRANS
;
ADREX7:	ORA	A
	RET
;
;
;
;
;ALL END
;
ALLEND:	CALL	FCLOSE
	LXI	H,MESS8
	CALL	MESSAGE
	JMP	REBOOT
;
;
;BEGIN MESSAGE
;
BEGMESS: DB '	ROM WRITER FOR AX68K',CR,LF
	DB 'THIS REQUIRES AT LEAST 40K CP/M.',CR,LF,CR,LF,0
;
;
;ROM WRITER
;
;THIS ROUTINE CHANGE DCOUNT
;
ROMWR:	XCHG
	SHLD	SPTR
	LHLD	DCOUNT
	MOV	A,H
	ORA	L
	RZ
;
	CPI	10H
	JC	ROMWR2	;NOT EXCEED ROM BUFFER
;
	JNZ	ROMWR1	;EXCEEDED
;
	XRA	A
	ORA	L
	JZ	ROMWR2
;
ROMWR1:	LXI	B,-(1000H)
	DAD	B
	SHLD	DCOUNT
	JMP	ROMWR3
;
ROMWR2:	LXI	H,0
	SHLD	DCOUNT
;
ROMWR3:	LXI	H,MESS14
	CALL	MESSAGE
	LXI	H,ADDR1
	CALL	PRADR
	LXI	H,MESS10
	CALL	MESSAGE
	LXI	H,ADDR2
	CALL	PRADR
	CALL	CRLF
;
	LXI	H,MESS5
	CALL	ASK
	JZ	ROMWR4
	CALL	SKPWR
	JNZ	ROMWR3
	JMP	ROMWR5
;
ROMWR4:	CALL	USRHI	;HIGH BYTE WRITE USER ROUTINE
;
ROMWR5:	LXI	H,MESS6
	CALL	ASK
	JZ	ROMWR7
	CALL	SKPWR
	JNZ	ROMWR5
	JMP	ROMWR9
;
ROMWR7:	CALL	USRLO	;LOW BYTE WRITE USER ROUTINE
ROMWR9:	LHLD	SPTR
	XCHG
	RET
;
;
;SKIP ROM WRITING
;IF CONTINUE THEN Z=0
;IF SKIP THEN Z=1
;IF NOT CONTINUE THEN JUMP TO MAIN
;
SKPWR:	LXI	H,MESS15
	CALL	ASK
	RZ
	LXI	H,MESS4
	CALL	ASK
	JNZ	SKPWR2
	ORA	A	;CLEAR Z-FLAG
	RET
;
SKPWR2:	CALL	FCLOSE
	JMP	MAIN
;
;
;
;*********************************************
;** THIS ROUTINE IS PECULIAR TO USER SYSTEM. **
;*********************************************
;
;
;TARGET DATA IS IN ROMBUFFER (ROMBUF) =1800H TO 27FFH
;
;
;HIGH BYTE WRITE.
;
;THIS ROUTINE REQUIRES Z-80 CPU
;
USRHI:	LXI	D,ROMBUF
USRHI0:	LXI	H,0
	LXI	B,1000H/2
;TIME DURATION
USRHI1:	PUSH	B
	LDAX	D
	CPI	0FFH
	JZ	USRHI8	;SKIP
;
	MVI	B,40H
	XRA	A
USRHI2:	DCR	A
	JNZ	USRHI2
	DCR	B
	JNZ	USRHI2
;1-BYTE WRITE
;IF DATA=0FFH THEN SKIP
;
	MOV	A,H
	ANI	7
	OUT	0AH
	MOV	A,L
	OUT	09
USRHI8:	LDAX	D
	INX	H
	INX	D
	INX	D	;SKIP 1-BYTE
	CPI	0FFH
	JZ	USRHI9
	OUT	8
	MOV	A,H
	OUT	0
	MVI	A,8
	OUT	0BH
USRHI9:	POP	B
	DCR	C
	JNZ	USRHI1
	DCR	B
	JNZ	USRHI1
;
	MVI	E,BELL
	MVI	C,CONOUT
	CALL	BDOS
;
	RET
;
;
;USER LOW BYTE WRITE ROUTINE
;
USRLO:	LXI	D,ROMBUF+1
	JMP	USRHI0
;
;
;
;INITIALIZE PROCEDURE
;
INIT:	LXI	H,BEGMESS ;BEGINING MESSAGE
	CALL	MESSAGE
	LHLD	CBASE	;GET CP/M TPA BOTTOM ADDRESS
	LXI	B,-20	;MARGIN
	DAD	B	;LABEL BUFFER SIZE TEST
	MOV	A,B
	CPI	80H
	JNC	INIT5	;NO ERROR
;
	LXI	H,ERMES1
	CALL	MESSAGE
	JMP	REBOOT
;
ERMES1:	DB 'NOT ENOUGH MEMORY !!',CR,LF,0
;
;
;CLEAR ADDR DATA BUFFER
;
INIT5:	LXI	H,ADDR
	MVI	B,(ADDR3+3)-ADDR+1
	XRA	A
INIT6:	MOV	M,A
	INX	H
	DCR	B
	JNZ	INIT6
	RET
;
;
;DISK READ FILE NAME SET
;
FNAME:	LXI	H,MESS1
	CALL	GETLN	;PRINT MESSAGE & GET LINE
	DCX	D
	LDAX	D	;CHARACTER COUNT
	INX	D
	ORA	A	;ZERO ?
	JZ	MAIN
;
	CALL	DVSET
	LDA	LINBUF-1	;CHARACTER COUNT
	ORA	A
	JZ	MAIN
	CALL	FCBSET
	RET
;
;
;DRIVE NUMBER SET
DVSET:	XRA	A
	STA	FCBO	;DEFAULT DRIVE
;PARMS FETCH
	CALL	SKPBLK
	INX	D
	LDAX	D
	CPI	':'	;NEXT CHAR=: ?
	DCX	D
	RNZ	;NO
;
;ADJUST CHARACTER COUNT
;
	DCX	D
	LDAX	D
	SUI	2
	STAX	D
	INX	D
;
	LDAX	D
	INX	D
	INX	D
	SUI	'A'-1
	STA	FCBO	;OBJ DRIVE NOMBER SET
	RET
;
;
;
;FILE CONTROL BLOCK SET
;
;INIT
;
;	DE=LINBUF CHAR. ADDRESS
;
FCBSET:	MVI	B,8
	LXI	H,FCBO+1
FCBSET3: MVI	M,SPACE
	INX	H
	DCR	B
	JNZ	FCBSET3
	XCHG
	LXI	D,FCBO+1
	LDA	LINBUF-1	;CHARACTER COUNT
	MOV	B,A
FCBSET1: MOV	A,M
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	FCBSET1
;
	LXI	D,FCBO+9
	MVI	B,24
	XRA	A
FCBSET2: STAX	D
	INX	D
	DCR	B
	JNZ	FCBSET2
	LXI	H,'OB'
	SHLD	FCBO+9
	MVI	A,'J'
	STA	FCBO+11	;FILE TYPE SET (OBJ)
	RET
;
;SET START ADDRESS TO ADDR
;THE ADDRESS DATA'S ORDER IS
;
;ADDR	LSB
;ADDR+1	MIDDLE
;ADDR+2	MIDDLE
;ADDR+3	MSB
;
;
SETADR:	LXI	H,0
	SHLD	ADDR
	SHLD	ADDR+2
	LXI	H,MESS7
	CALL	GETLN
SETA1:	LDAX	D
	CALL	HEXNUM	;HEX NUMBER ?
	JC	SETA3	;NO
	LHLD	ADDR+2
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LDA	ADDR+1
	RAR
	RAR
	RAR
	RAR
	ANI	0FH
	ORA	L
	MOV	L,A
	SHLD	ADDR+2
	LDAX	D
	CALL	AHT	;ASCII TO HEX TRANSFORM
	LHLD	ADDR
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ORA	L
	MOV	L,A
	SHLD	ADDR
	INX	D
	DCR	B	;ALL CHARACTER SEARCHED ?
	JNZ	SETA1	;NO
	LDA	ADDR
	ANI	0FH
	JNZ	SETADR
	RET
;
SETA3:	CALL	CONTI
	JZ	SETADR
	JMP	ALLEND
;
;
;** SOURCE FILE READ PROCEDURE
;
;TEST THAT SOURCE BUFFER IS EMPTY ?
;OR SOURCE POINTER (DE) REACHED THE LIMIT OF SOURCE BUFFER ?
;THEN READ SOURCE FILE FROM DISK
;AND RE-CONFIGURE THEM.
;
;
;ENTRY CONDITION
;
;DE=SOURCE BUFFER POINTER
;
;AT THE BEGINING OF ASSEMBLE,
;IF YOU WANT TO MAKE THIS SUBROUTINE READ THE SOURCE FILE,
;SET DE INIT. TO OBJBUF+OBJBSZ. 
;IN THIS CASE, THE VALUE OF DE AT THE EXIT OF THIS ROUTINE
;IS OBJBUF+256
;(INDICATES SOURCE TOP.)
;
;(IT IS SUPPOSED THAT THE FCB ALREADY BE SET AND
;SOURCE FILE WAS OPENED OF COURCE.)
;
;
;
READSC:	PUSH	D
	LXI	H,-(OBJBUF+OBJBLT) ;-(SOURCE BUFFER LIMIT)
	DAD	D	;POINTER REACHED LIMIT ?
	POP	D
	RNC	;NO
;
	PUSH	D
	LXI	D,OBJBUF
	LXI	H,OBJBUF+OBJBLT
	MVI	B,0	;(256 COUNTS)
;
;REMAINING 256 BYTES RE-CONFIGURE
;TO SOURCE TOP 256 AREA
;
READS1:	MOV	A,M
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	READS1
;
;READ FROM DISK
;
	LXI	H,OBJBUF1 ;=OBJBUF+256
	LXI	D,FCBO	;SOURCE FCB
	MVI	B,OBJBLT/128 ;READ COUNTS
READS2:	CALL	DLOAD	;READ FILE 128 BYTES
	ORA	A	;FILE END ?
	JNZ	READS3	;YES
	DCR	B
	JNZ	READS2
READS3:	POP	D	;RECALL SOURCE POINTER
	LXI	H,-(OBJBLT)
	DAD	D	;COMPENSATE THE POINTER
	XCHG
	RET	;THE DE IS COMPENSATED.
;
;OPEN SOURCE FILE
;
;
FOPEN:	LXI	D,FCBO
	MVI	C,OPEN	;SET SYSTEM CALL PARAMETER
	CALL	BDOS	;OPEN IT
	INR	A	;A=0FFH ?
	LXI	H,NOFILE
	JZ	DSKERR	;NO SOURCE FILE
;
	RET
;
;
;CLOSE FILE
;
FCLOSE:	LXI	D,FCBO
	MVI	C,CLOSE
	CALL	BDOS
	RET
;
;
;DATA LOAD FROM DISK
;
;INIT
;
;	DE=FCB ADDRESS
;DATA IS LOADED FROM (HL) TO (HL)+128
;
;AT ENTERING THIS ROUTINE
; FCB MUST HAS BEEN SET ALREADY.
; AND FILE HAS BEEN OPENED.
;
;FINAL STATE IS AS FOLLOWS
;HL=HL+128
;BC,DE =CONSERVED
;IF A=0 THEN FILE IS REST.
; ELSE END OF FILE.
;
DLOAD:	PUSH	B
	PUSH	H
	PUSH	D
	XCHG
	MVI	C,SETDMA
	CALL	BDOS	;SET DMA ADDRESS
	POP	D
	PUSH	D
	MVI	C,READS
	CALL	BDOS	;READ SECTOR
	POP	D
	LXI	B,128
	POP	H
	DAD	B
	POP	B
	RET
;
;
;DISK I/O ERROR
;
DSKERR:	CALL	MESSAGE
	JMP	MAIN
;
;
;DISK I/O ERROR MESSAGE
;
NOFILE:	DB CR,LF,'NO SOURCE FILE',CR,LF,0
;
;SKIP BLANK
;
SKPBLK: LDAX	D
	INX	D
	CPI	SPACE
	JZ	SKPBLK
	DCX	D
	RET
;
;HEX NUMBER TEST
;
;IF HEX THEN CY=0
;
HEXNUM:	LDAX	D
	CPI	'0'
	RC
	CPI	'9'+1
	CMC
	RNC
	CPI	'A'
	RC
	CPI	'G'
	CMC
	RET
;
;
;16-BIT ASCII TO HEX EXTRACT
;
;IF HIT THEN CY=0
;AND H=FIRST BYTE, L=LAST BYTE
;B=BYTE COUNT
;
EXTHEX:	MVI	B,0
	CALL	DHEXNM
;DOUBLE HEX EXTRACT
;IF HIT THEN CY=0 AND DATA IS IN L REGISTER.
;
	RC	;NOT HEX
	INR	B
	MOV	H,L
	CALL	DHEXNM
	JC	EXTHX2	;1-BYTE DATA
	INR	B
EXTHX2:	ORA	A	;CY=0
	RET
;
;DOUBLE BYTE ASCII CHARACTER HEX TRANS
;
;IF HIT THEN CY=0
;SAVE H,B
;IF NOT HIT THEN SAVE DE.
;
DHEXNM:	PUSH	D
	CALL	HEXNUM
	JC	DHXN4
	INX	D
	CALL	AHT
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	MOV	L,A
	CALL	HEXNUM
	JC	DHXN4
	INX	D
	CALL	AHT
	ORA	L
	MOV	L,A
	POP	A
	ORA	A
	RET
;
DHXN4:	POP	D
	STC
	RET
;
;
;ASCII TO HEX TRANSFORM
;DATA=IN A REGI.
;RESULT=IN A REGI.
;
AHT:	ANI	4FH
	SUI	37H
	RNC
	ADI	37H
	RET
;
;HEX TO ASCII TRANS.(DOUBLE)
;
;INIT.
;DE=DATA POINTER
;HL=STORE ADDRESS POINTER
;
;FINAL
;DE=DE-1
;RESULT=STORE TO (HL),(HL)+1
;HL=HL+2
;
DHAT2:	LDAX	D
	DCX	D
DHAT:	PUSH	A
	RAR!RAR!RAR!RAR
	CALL	HAT
	POP	A
HAT:	ANI	0FH
	CPI	0AH
	JC	HAT1
	ADI	7
HAT1:	ADI	30H
	MOV	M,A
	INX	H
	RET
;
;
;
;
;** SUBROUTINES FOR PRINT
;
;
;TRANSLATE 2 BYTES HEX TO ASCII
; (DE)-2 >> (HL)+4 & INSERT SPACE
;
;ENTRY CONDITION
;
;DE=HEX SOURCE POINTER
;HL=DESTINATION POINTER
;
;REGI.USE=AFDEHL
;
;EXIT CONDITION
;
;DE=DE-2
;HL=HL+5
;AF=UNDIFINED
;
QHAT:	CALL	DHAT2	;1 BYTE TRANS.
	CALL	DHAT2
	MVI	M,20H	;SPACE
	INX	H
	RET
;
;
;PRINT 32-BIT ADDRESS
;FROM (HL)
;
PRADR:	PUSH	D
	LXI	B,3
	DAD	B
	XCHG
	LXI	H,LINBUF
	CALL	QHAT
	CALL	QHAT
	MVI	M,0
	LXI	H,LINBUF
	CALL	MESSAGE
	POP	D
	RET
;
;INCREMENT ADDRESS POINTER
;
;INCREMENT (BC) AND TRANSFER TO (HL)
;
ADRADD:	PUSH	H
	LXI	H,NBUF2
	CALL	TRANS
	LXI	H,0
	SHLD	NBUF1+1
	LXI	H,1000H
	SHLD	NBUF1
;SET ARITHMETIC OPERATION BUFFER
;
	CALL	NADD	;ADDITION
;RESULT DESTINATION IS NBUF2
;
	POP	H
	LXI	B,NBUF2
	CALL	TRANS
	RET
;
;32-BIT ADDITION
;
;(NBUF1)+(NBUF2)>>(NBUF2)
;
NADD:	PUSH	D
	LXI	D,NBUF1
	LXI	H,NBUF2
	MVI	B,4
	ORA	A
NADD2:	LDAX	D
	ADC	M
	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	NADD2
	POP	D
	RET
;
;32-BIT SUBTRACT
;
;(NBUF2)-(NBUF1)>>(NBUF2)
;
NSUB:	PUSH	D
	LXI	H,NBUF1
	LXI	D,NBUF2
	MVI	B,4
	ORA	A
NSUB2:	LDAX	D
	SBB	M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	NSUB2
	POP	D
	RET
;
;
;32-BIT ADDRESS COMPARE
;
;(BC)-(HL)
;IF (BC)<(HL),THEN CY=1
;IF (BC)=(HL),THEN Z=1
;
;
ADRCMP:	PUSH	D
	PUSH	B
	POP	D
	LXI	B,4
	DAD	B
	XCHG
	DAD	B
	XCHG
ADRCP2:	DCX	D
	DCX	H
	LDAX	D
	CMP	M
	JNZ	ADRCP3
	DCR	C
	JNZ	ADRCP2
;
ADRCP3:	POP	D
	RET
;
;
;TRANSFER 32-BIT DATA
;
;(BC)>>(HL)
;
TRANS:	PUSH	D
	PUSH	B
	POP	D
	MVI	B,4
TRANS2:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	TRANS2
	POP	D
	RET
;
;PRINT CR/LF
;
CRLF:	PUSH	D
	MVI	E,CR
	MVI	C,CONOUT
	CALL	BDOS
	MVI	E,LF
	MVI	C,CONOUT
	CALL	BDOS
	POP	D
	RET
;
;PRINT TAB
;
PRTAB:	PUSH	D
	MVI	E,TAB
	MVI	C,CONOUT
	CALL	BDOS
	POP	D
	RET
;
;
;ASK YES OR NO
;
ASK:	CALL	MESSAGE
	CALL	PRTAB
	CALL	GETCH
	PUSH	A
	CALL	CRLF
	POP	A
	CPI	'Y'
	RET
;
;
;GET 1 CHARACTER
;
GETCH:	PUSH	D
	MVI	C,CONIN
	CALL	BDOS
	POP	D
	RET
;
;PRINT MESSAGE FROM (HL)
;AND GET LINE INTO LINEBUFFER (LINBUF).
;FINIT.DE=LINBUF AND B=THE NUMBER OF CHAR.READ
;
GETLN:	CALL	MESSAGE
	LXI	D,LINBUF-2
	MVI	A,90
	STAX	D	;SET LINE CHAR COUNTS
	MVI	C,CONRD	;CONSOLE READ LINE SYSTEM CALL
	CALL	BDOS
	LDA	LINBUF-1
	MOV	B,A
	LXI	D,LINBUF
	RET
;
;
;ASK CONTINUE ?
;
CONTI:	LXI	H,MESS4
	CALL	ASK
	CPI	'Y'
	RET
;
;
;PRINT MESSAGE TO CONSOLE
;
;FROM (HL)~ UNTIL HIT 0H
;BC,DE CONSERVED
;
MESSAGE:	PUSH	D
	PUSH	B
MSG1:	MOV	A,M
	ORA	A
	JZ	MSG2
	INX	H
	PUSH	H
	MOV	E,A
	MVI	C,CONOUT
	CALL	BDOS
	POP	H
	JMP	MSG1
;
MSG2:	POP	B
	POP	D
	RET
;
;
;MESSAGES
;
MESS1:	DB 'TYPE YOUR .OBJ FILE NAME.',CR,LF,0
MESS2:	DB 'WRITING OK ?	Y/N',CR,LF,0
MESS4:	DB 'CONTINUE ?	Y/N ',0
MESS5:	DB 'SET 1','''','ST ROM (HIGHER BYTE ROM).',CR,LF
	DB 'READY ?	Y/N',0
MESS6:	DB 'SET 2','''','ND ROM (LOWER BYTE ROM).',CR,LF
	DB 'READY ?	Y/N',0
MESS7:	DB 'TYPE START ADDRESS.',CR,LF
	DB '(LOWER 4-BITS OF ADDRESS MAST BE 0.)',CR,LF
	DB 'START ADDRESS= ',0
MESS8:	DB CR,LF,'WRITING IS END.',CR,LF,0
MESS9:	DB CR,LF,'SKIP AREA FROM ',0
MESS10:	DB 'TO ',0
MESS11:	DB CR,LF,'MINUS SKIP ??',CR,LF,0
MESS12:	DB CR,LF,'TOO LARGE SKIP.',CR,LF,0
MESS13:	DB CR,LF,'ERROR AT ',0
MESS14:	DB CR,LF,'PROM WRITE . ADDRESS = ',0
MESS15:	DB 'DO YOU WANT TO SKIP THE WRITING ?	Y/N ',0
;
;
;WORK AREA
;
;ADDRESS DATA ORDER IS
;
;ADDR=LSB
;ADDR+1=MIDDLE LOW
;ADDR+2=MIDDLE HIGH
;ADDR+3=MSB
;
ADDR:	DS	4	;OBJECT ADDRESS
ADDR1:	DS	4	;WRITE START ADDRESS
ADDR2:	DS	4	;WRITE END ADDRESS
ADDR3:	DS	4	;EXTRACTED ADDRESS
SPTR:	DS	2
SPTR2:	DS	2
;
;NUMBER OPERATION BUFFER
;
;THE ORDER OF DATA IS
;
;NBUF=LSB
;NBUF+1=MIDDLE LOW
;NBUF+2=MIDDLE HIGH
;NBUF+3=MSB
;
NBUF1:	DS	4
NBUF2:	DS	4
NBUF3:	DS	4
NBUF4:	DS	4
DCOUNT:	DS	2
;
LINBUF: DS	100
FCBO:	DS	33
	DS	100
STACK:
;
;
END
