/*	MTVMAIN.C	4/23/84 - 05/26/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.0
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>

/*
*	PROCESS DESCRIPTOR EQUATES
*/

#define PROCAX 0x00
#define PROCBX 0x02
#define PROCCX 0x04
#define PROCDX 0x06
#define PROCSI 0x08	
#define PROCDI 0x0A
#define PROCBP 0x0C	
#define PROCES 0x0E
#define PROCDS 0x10	
#define PROCSS 0x12	
#define PROCSP 0x14	
#define TOPOFMEM 0x16
#define PSPSEG 0x18
#define CURRDSK 0x1a
#define ROWCOL 0x1c
#define DTAOFF 0x1e
#define DTASEG 0x20
#define CVIDMOD 0x22
#define CACTPAG 0x23

#define PDSIZE	0x40

#define MAXCHNLS 10

typedef struct pd_blk
{
	WORD		p_inf10;
	UWORD		p_mchnl;
	LONG		p_chseg;
	LONG		p_f10bf;
	UWORD		p_regs[12];
	UWORD		p_stack[128];
} PD;

EXTERN LONG	dos_alloc();
EXTERN LONG	dos_avail();
EXTERN WORD	dos_free();
EXTERN LONG	dos_gdta();

EXTERN VOID	setinigl();
EXTERN VOID	grabfunc();
EXTERN VOID	scrncfig();
EXTERN VOID	sti();
EXTERN VOID	cli();
EXTERN VOID	freeinit();
EXTERN LONG	pathinit();
EXTERN VOID	setmemgl();
EXTERN VOID	chnalloc();
EXTERN VOID	gotoit();

EXTERN VOID	bldcline();
EXTERN VOID	initdisp();
EXTERN WORD	initvid();
EXTERN VOID	initdirs();
EXTERN VOID	initstk();
EXTERN VOID	setchngl();

EXTERN VOID	chkpaths();

EXTERN WORD	PROGEND;

GLOBAL LONG	ad_psp;
GLOBAL LONG	ad_envrn;
GLOBAL LONG	ad_cspec;
GLOBAL LONG	ad_paths;
GLOBAL LONG	ad_memst;
GLOBAL LONG	ad_memsz;

GLOBAL WORD	gl_nmdisk;
GLOBAL WORD	gl_chnlsz;
GLOBAL WORD	gl_currchnl;
GLOBAL WORD	gl_numchnls;
GLOBAL UWORD	*gl_dostk;
GLOBAL PD	gl_pds[MAXCHNLS];
GLOBAL PD	*rlr;

GLOBAL WORD	ax_reg;
GLOBAL WORD	bx_reg;
GLOBAL WORD	cx_reg;
GLOBAL WORD	dx_reg;
GLOBAL WORD	si_reg;
GLOBAL WORD	di_reg;
GLOBAL WORD	ds_reg;
GLOBAL WORD	es_reg;
GLOBAL WORD	ss_reg;
GLOBAL WORD	sp_reg;
GLOBAL WORD	bp_reg;
GLOBAL WORD	flg_reg;

GLOBAL BYTE	tmptext[128];


	VOID
dofunc09(pf09buff)
	LONG		pf09buff;
{
	WORD		ch;

	while ( (ch = LBGET( pf09buff++ )) != '$' )
	  conout(ch);
}


	VOID
dofunc10(pf10buff)
	LONG		pf10buff;
{
	WORD		ch, ptr, len;

	len = LBGET( pf10buff );
	ptr = 1;
	do
	{
	  ch = conin();
	  if ( (ptr-1) < len )
	  {
	    if ( ch == 0x08 )
	    {
	      if (ptr > 1)
	      {
	        ptr--;
	        conout(0x08);
	        conout(0x20);
	        conout(0x08);
	      }
	      ch = 0x0;
	    }
	    else
	    {
	      ptr++;
	      LBSET( pf10buff + ptr, ch );
	    }
	  }
	  else
	    ch = 0x07;
	  if (ch)
	    conout( ch );
	} while ( ch != 0x0d );
	LBSET( pf10buff + 1, 0x00ff & (ptr - 2) );
}


	LONG
getadscr(chnlnum)
	WORD		chnlnum;
{
	return( (gl_pds[chnlnum].p_chseg & 0xffff0000L) | 0x00001410L );
}


	WORD
doscall(chnlnum)
	WORD		chnlnum;
{
	WORD		ah;

	ah = ((ax_reg & 0xff00) >> 8);
	LWCOPY( ADDR(&rlr->p_regs[0]), ADDR(&ax_reg), 12);
	switch( ah )
	{
	   case 0x09:
		dofunc09(dx_reg, ds_reg);
		chnlnum |= 0xff00;
		break;
	   case 0x0A:
		dofunc10(dx_reg, ds_reg);
		chnlnum |= 0xff00;
		break;
	}
	LWCOPY( ADDR(&ax_reg), ADDR(&rlr->p_regs[0]), 12);
						/* remember new top guy	*/
						/*   in case it changed	*/
	return( chnlnum );
}



	WORD
doswitch(chnlnum)
	WORD		chnlnum;
{
	LONG		padscrn;
	WORD		ch, done, i;
	UWORD		psp;
						/* save contents under	*/
						/*   the line		*/
	saveline();
						/* interact for a while	*/
	done = FALSE;
	while( !done )
	{
						/* get process desc.	*/
	  padscrn = getadscr( chnlnum );
						/* find program name	*/
	  psp = LWGET(padscrn + PSPSEG);
						/* build line to show	*/
	  bldcline(chnlnum, gl_pds[chnlnum].p_mchnl, 
		ADDR("FILENAME.TXT"));
						/* show the control line*/
	  showline();
						/* get characters	*/
	  switch( ch = conin() )
	  {
	     case '>':
		if (chnlnum < (gl_numchnls - 1))
		  chnlnum++;
		break;
	     case '<':
		if (chnlnum > 0)
		  chnlnum--;
		break;
	     case 0x0d:
		done = TRUE;
		break;
	  }
	}
						/* restore previous line*/
	hideline();
						/* remember new top guy	*/
	return( gl_currchnl = chnlnum );
}


	VOID
loaddisk(padscrn)
	LONG		padscrn;
{
	WORD		cdsk, pdsk;
						/* set process dta	*/
	dos_sdta( LLGET(padscrn + DTAOFF) );
						/* get current disk	*/
	cdsk = dos_gdrv();
						/* get process disk	*/
	pdsk = LWGET(padscrn + CURRDSK);
						/* if not same then 	*/
						/*   select it		*/
	if ( cdsk != pdsk )
	  dos_sdrv(pdsk);

	chkpaths( padscrn, ad_paths, gl_nmdisk );
}


	VOID
loadmemst(padscrn)
	LONG		padscrn;
{
	UWORD		memoff, memseg, topmem;

	memoff = LHIWD( LLDS() );
	memoff -= ( memseg = LHIWD(ad_memst) - 1 );
	if ( !memoff )
	{
	  memoff--;
	  LWSET(0x0003, memseg, memoff);
	}
	memoff = topmem = LWGET( padscrn + TOPOFMEM );
						/* if top of mem	*/
						/*   then set end of	*/
						/*   mem list		*/
	if ( !memoff )
	{
	  memseg = memoff;
	  LBSET(0x0000, memseg, 'Z');
	  memoff = ((UWORD) (ad_memsz >> 4L));
	  memoff -= topmem;
	  memoff--;
	  LWSET(0x0003, memseg, memoff);
	}
}

	VOID
savedisk(padscrn)
	LONG		padscrn;
{
	LWSET(padscrn + CURRDSK, dos_gdrv());
	LLSET(padscrn + DTAOFF, dos_gdta());
}


	VOID
savememst(padscrn)
	LONG		padscrn;
{
	UWORD		memoff, memseg, cs;

	memseg = LHIWD(ad_memst) - 1;
	LWSET(0x0001, memseg, cs = LHIWD(LLCS()) );
	LWSET(0x0003, memseg, gl_chnlsz );
	memoff = LWGET( padscrn + TOPOFMEM );
						/* if top of mem	*/
						/*   then set end of	*/
						/*   mem list		*/
	if ( !memoff )
	{
	  memseg = memoff;
	  LBSET(0x0000, memseg, 'M');
	  LWSET(0x0001, memseg, cs );
	  LWSET(0x0003, memseg, gl_chnlsz);
	}
}

	VOID
saveproc(padscrn)
	LONG		padscrn;
{
						/* remember video state	*/
	savevid(padscrn);
						/* save away screen buff*/
	savescbf(padscrn);
						/* copy out int. page	*/
	LWCOPY((padscrn & 0xffff0000L) | 0x00001010L, 0x0L, 0x200);
						/* fix up memory blocks	*/
	savememst(padscrn);
						/* remember psp segment	*/
	LWSET(padscrn + PSPSEG, dos_gpsp() );
						/* remember disk state	*/
	savedisk(padscrn);
}


	LONG
loadproc(chnlnum)
	WORD		chnlnum;
{
	LONG		padscrn;
	UWORD		cv;
						/* set internal pd	*/
	rlr = &gl_pds[chnlnum];
						/* set base of curr stk	*/
	gl_dostk = &rlr->p_stack[127];
						/* get process desc.	*/
	padscrn = getadscr( chnlnum );
						/* restore video envirn.*/
	loadvid( cv = LWGET(padscrn + CVIDMOD), LWGET(padscrn + ROWCOL) );
						/* restore screen buffer*/
	loadscbf( padscrn, cv );
						/* copy out int page	*/
	LWCOPY(0x0L, (padscrn & 0xffff0000L) | 0x00001010L, 0x200);
						/* set psp segment	*/
	dos_spsp( LWGET(padscrn + PSPSEG) );
						/* restore disk environ.*/
	loaddisk( padscrn );
						/* fix up memory around	*/
						/*   this process	*/
	loadmemst( padscrn );
						/* return ax,bx with	*/
						/*   address of padscrn	*/
	return( padscrn );
}


	VOID
initpsp(pspoff, pspseg, topmem)
	UWORD		pspoff;
	UWORD		pspseg;
	UWORD		topmem;
{
	WORD		i;
						/* remember top of mem	*/
						/*   for this process	*/
	LWSET(pspoff+TOPOFMEM, pspseg, topmem);
						/* clear out registers	*/
	for(i=0; i<7; i++)
	  LWSET(pspoff+PROCAX+(i*2), pspseg, 0x0000);
						/* set up segment regs	*/
	LWSET(pspoff+PROCES, pspseg, LHIWD(LLCS()) );
	LWSET(pspoff+PROCDS, pspseg, LHIWD(LLCS()) );
	LWSET(pspoff+PROCSS, pspseg, pspseg);
						/* set up stack pointer	*/
	LWSET(pspoff+PROCSP, pspseg, pspoff+PDSIZE-6);
}


	LONG
grabmem(chnlnum, numchnls, pchamt)
	WORD		chnlnum;
	WORD		numchnls;
	LONG		*pchamt;
{
	LONG		amtreq, amtavl;

	amtavl = dos_avail();

	if (numchnls - chnlnum - 1)
	{
	  amtreq = LW( gl_pds[chnlnum].p_mchnl ) << 10L;
	  if (amtreq > amtavl)
	    amtreq = amtavl;
	}
	else
	  amtreq = amtavl;

	*pchamt = amtreq;

	gl_pds[chnlnum].p_mchnl = ((UWORD) (amtreq >> 10L) );

	return( dos_alloc( amtreq ) );
}

	VOID
initchnl(chnlnum, numchnls)
	WORD		chnlnum;
	WORD		numchnls;
{
	LONG		padscrn, padchnl;
	LONG		chamt;
	WORD		topmem;

	gl_pds[chnlnum].p_chseg = dos_alloc( LW(gl_chnlsz) << 4L ) - 0x10000L;

	padscrn = getadscr( chnlnum );

	padchnl = grabmem( chnlnum, numchnls, &chamt);

	topmem = LHIWD(padchnl) + ((UWORD) (chamt >> 4L)) + gl_chnlsz + 2;

	if ( topmem == ((UWORD) (ad_memsz >> 4L)) )
	  topmem = 0x0;
						/* init the psp		*/
	initpsp(padscrn, topmem);
						/* fix up initial screen*/
	bldcline(chnlnum, gl_pds[chnlnum].p_mchnl, ADDR("START.EXE"));
	initdisp(padscrn);
						/* copy out int page	*/
	LWCOPY((padscrn & 0xffff0000L) | 0x00001010L, 0x0L, 0x200);
						/* remember psp segment	*/
	LWSET(padscrn + PSPSEG, dos_gpsp() );
						/* init row,col to 1,0	*/
	LWSET(padscrn + ROWCOL, 0x0100 );
						/* init video mode	*/
	LWSET(padscrn + CVIDMOD, initvid() );
						/* init default dirs for*/
						/*   for this pd	*/
	initdirs(padscrn);
						/* make stack point at	*/
						/*   exec code		*/
	initstk(padscrn);
						/* return whether there	*/
						/*   is more memory or	*/
						/*   not		*/
	return( topmem == 0x0 );
}


	WORD
chnalloc(numchnls)
	WORD		numchnls;
{
	WORD		count, chnlnum, chnlcnt;

	count = numchnls;
	chnlnum = 0;
	while (count)
	{
	  count--;
	  if ( initchnl(chnlnum++, numchnls) )
	    break;
	}

	setchngl(chnlnum);
	return( (chnlnum == numchnls) );
}

	VOID
grfalloc()
{
}

	VOID
calcmem()
{
	ad_memst = dos_alloc( ad_memsz = dos_avail() );
	ad_memsz += ad_memst >> 12L;
	dos_free( ad_memst );
}

	VOID
fixmblks(memst, chnlsz, memsz)
	LONG		memst;
	WORD		chnlsz;
	WORD		memsz;
{
	UWORD		ax;
	UWORD		allmem;

	ax = LHIWD(ad_memst) - 1;
	allmem = ((UWORD) (ad_memsz >> 4L) );
	do
	{
	  ax += chnlsz;
	  ax++;
	  LWSET(0x0001, ax, 0x0);
	  ax += LWGET(0x0003, ax);
	  ax++;
	}while (ax != allmem);
}

	LONG
pathinit(nmdisk)
	WORD		nmdisk;
{
	WORD		i, count;
	LONG		plong;
						/* calc bytes to alloc	*/
	count = nmdisk;
	count <<= 6;
	plong = dos_alloc( LW(count) );
						/* convert to words	*/
	count >>= 1;
						/* zero out the words	*/
	for(i=0; i<count; i++)
	  LWSET(plong + i, 0x0000);
						/* return path segment	*/
	return(plong);
}


	VOID
diskcfig()
{
	WORD		currdisk;

	currdisk = dos_gdrv();
	gl_nmdisk = dos_sdrv(currdisk);
}


	VOID
calcchsz()
{
	WORD		ax;

	ax = gl_nmdisk;
	ax <<= 6;
	ax += PDSIZE + 0x000f;
	ax >>= 4;
	ax += 0x0140;
	gl_chnlsz = ax;
}

	VOID
proctail()
{
	BYTE		tail[0x80];
	BYTE		ch, *ptail;
	WORD		chsize;

	LBCOPY(ADDR(&tail[0]), ad_psp+0x80, 0x80);
	tail[ tail[0] + 1 ] = NULL;

	gl_numchnls = 0;
						/* parse the tail	*/
	ptail = &tail[1];
	if (*ptail)
	{
						/* pick up first char	*/
	  while( ch = toupper(*ptail++) )
	  {
						/* accumulate a number	*/
	    chsize = 0;
	    while ( (ch >= '0') &&
	            (ch <= '9') )
	    {
	      chsize *= 10;
	      chsize += ch - '0';
	      ch = toupper(*ptail++);
	    }
						/* store the channel sz	*/
	    if (chsize)
	      gl_pds[gl_numchnls++].p_mchnl = chsize;
	  }
	}
	else
	{
						/* no command tail	*/
	  gl_numchnls = 1;
	  gl_pds[0].p_mchnl = 180;
	}
	gl_numchnls++;
}

main()
{
						/* ad_psp, ad_envrn, 	*/
						/*   have already been	*/
						/*   set		*/
	getcspec(ad_envrn);
						/* get gl_nmdisk	*/
	diskcfig();
						/* get & set screen parm*/
	scrncfig();
						/* get gl_chnlsz	*/
	calcchsz();
						/* get gl_mchnl &	*/
						/*   gl_numchnls	*/
	proctail();
						/* set cs values	*/
	setinigl(gl_nmdisk, gl_chnlsz);
						/* steal all interrupts	*/
	grabfunc();
						/* ints on for now	*/
	sti();
						/* shrink down to end	*/
						/*   of program		*/
	freeinit(&PROGEND, ad_psp);
						/* init memory to hold	*/
						/*   default paths	*/
	ad_paths = pathinit(gl_nmdisk);
						/* alloc mem for graphic*/
						/*   channels		*/
	grfalloc();
						/* get ad_memst, ad_memsz*/
	calcmem();
						/* set CS based globals	*/
	setmemgl(ad_paths, ad_memst, ((UWORD) (ad_memsz >> 4L) ) );
						/* allocate channels	*/
	if ( !chnalloc(gl_numchnls) )
	  printf("\r\nAll partitions not created.$");
						/* fix memory blocks	*/
	fixmblks(ad_memst, gl_chnlsz, ad_memsz);
						/* no ints for a while	*/
	cli();
						/* start switching	*/
						/* set internal pd	*/
	rlr = &gl_pds[0];
	gotoit();
}
