/* memfns - collect all mem functions into one module 
 *
 * functions:
 *	ptr = memset(s, c, n)
 *	ptr = memcpy(s1, s2, n)
 *	rc = memcmp(s1, s2, n)
 *	ptr = memchr(s,c,n)
 *	ptr = memccpy(s1, s2, c, n)
 *
 * revisions:
 *	gathered together 2/85 whf
 */

/* memset - set first n characters of s to n
**
** calling sequence:
**	ptr = memset(s, c, n)
**
** return:
**	ptr = s
**
*/

char	*
memset(s, c, n)
char	*s;
int	c, n;
{

	register	char	*ts;

	ts = s;
	while(n--)
		*ts++ = c;

	return(s);
}


/* memcpy - copy n characters of s2 to s1
**
** calling sequence:
**	ptr = memcpy(s1, s2, n)
**
** return:
**	ptr = s1
**
*/

char	*
memcpy(s1, s2, n)
char	*s1, *s2;
int	n;
{
	register	char	*ts1 = s1;
	register	char	*ts2 = s2;

	while(n--)
		*ts1++ = *ts2++;
	return(s1);
}
	



/* memcmp - compare first n characters of s1 and s2
**
** calling sequence:
**	rc = memcmp(s1, s2, n)
**
** return:
**	rc = 0 --> s1 = s2
**	rc < 0 --> s1 < s2
**	rc > 0 --> s1 > s2
**
*/
int
memcmp(s1, s2, n)
char	*s1, *s2;
int	n;
{

	register	char	*ts1;
	register	char	*ts2;

	ts1 = s1;
	ts2 = s2;
	while(n--)
		if(*ts1++ != *ts2++)
			return(*--ts1 - *--ts2);
	return(0);
}




/* memchr - find first occurrence of c in the first n characters of s
**
** calling sequence:
**	ptr = memchr(s,c,n)
**
** retrun:
**	ptr is a pointer to the first occurrence of c or a null if c
**	does not exist in the first n characters of s
**
*/

char	*
memchr(s,c,n)
char	*s;
int	c, n;
{

	register	char	*ts;

	ts = s;
	while(n--)
		if(*ts++ == c)
			return(ts-1);

	return(0);
}



/* memccpy - copy s2 to s1 stopping after the first occurrence
**	     of the character c or n characters have been copied
**	     whichever comes first.
**
** calling sequence:
**	ptr = memccpy(s1, s2, c, n)
**
** return:
**	ptr is a pointer to the character after c in s1 or a null pointer
**	if c was not found in the first n characters of s2
**
*/

char	*
memccpy(s1, s2, c, n)
char	*s1, *s2;
int	c, n;
{

	register	char	*ts1;
	register	char	*ts2;

	ts1 = s1;
	ts2 = s2;
	while(n--)
		if((*ts1++ = *ts2++) == c)
			return(ts1);
	return(0);
}
                                                         