
/*
 *	NAME:	execl
 *
 *	FUNCTION:
 *		The execl function is called from anywhere to pass control to
 *		another program from the the executing C program.
 *		Note that the stream files are closed via '_cleanup()'.
 *
 *	USAGE:
 *		int	execl(name,arg0,arg1,...,argn,NULLPTR);
 *
 *	ARGUMENTS:
 *		char *	name, arg0, arg1...argn -> pointers to character
 *
 *	RETURNS:
 *		FAILURE (-1) if file not found.
 *
 *	REVISIONS:
 *		execl for pcdos 2.0 may,84  AS
 *		split into separate files for pcdosb 12/84 JC
 *		replaced conditional expressions 2/85 JC
 *
*/

#include "portab.h"
#include "osif.h"
#if CPM
#include "osiferr.h"
#include "errno.h"
#include "ctype.h"

int
execl(name,arg0)			/* CLEAR FUNCTION ***********/
char *name,*arg0;			/* pointers arguments	   */
{					/*			   */

  REG	UBYTE **args;				/* used to index into args */
	UBYTE cmdline[128];			/* CP/M command line area  */
  REG	WORD  i;				/***************************/

	_cleanup();				/* Close all (stream) files*/
						/* now build cmdline	   */
	strcpy(cmdline,name);			/* Copy name portion	   */
	for(i = strlen(cmdline); --i >= 0; )	/* uppercase command name  */
	  cmdline[i] = toupper(cmdline[i]);	/*			   */
	args = &arg0;				/* Copy args		   */
	args++; 				/* arg0 is a dup of the    */
	while(*args != NULLPTR) 		/***************************/
	  {					/*			   */
	    strcat(cmdline," ");                /* Add a blank             */
	    strcat(cmdline,*args++);		/* Add next arg 	   */
	  }					/***************************/
	__OSIF(SETDMA,cmdline);			/* DMA -> command line	   */
	__OSIF(P_CHAIN,0);			/* chain to program	   */
	RETERR(FAILURE,ENOENT); 		/* error: file not found   */
}						/***************************/
#endif

#if PC1ONLY

int
execl(name,arg0)			/* CLEAR FUNCTION ***********/
char *name,*arg0;			/* pointers arguments	   */
{					/*			   */
	return(_execl3(name,arg0));
}
#endif

#if PC2ONLY

int
execl(name,arg0)			/* CLEAR FUNCTION ***********/
char *name,*arg0;			/* pointers arguments	   */
{					/*			   */
	return(_execl4(name,arg0));
}
#endif

#if PCBOTH
#include "osattr.h"
int
execl(name,arg0)			/* CLEAR FUNCTION ***********/
char *name,*arg0;			/* pointers arguments	   */
{					/*			   */
	if (os_unixlike)
		return(_execl4(name,arg0));
	else
		return(_execl3(name,arg0));
}
#endif
                                          