
/*
*	NAME: creat
*
*	FUNCTION:
*	  The "creat" routine opens a new "C" file and returns a file id.
*	  comes in 3 flavors: ascii (CP/M text files), binary, and default
*	  (currently ascii).
*
*	USAGE:
*		int	creat(fname,prot)
*		int	creata(fname,prot)
*		int	creatb(fname,prot)
*		int	_creat(fname,prot,type);
*
*	ARGUMENTS:
*	  char	*fname	address of a null terminated file name.
*	  int	prot	is the UNIX file protection
*	  int	type	is 0 for ASCII, 1 for BINARY
*
*	RETURNS:
*		FAILURE (-1) if unsuccesful, else file descriptor
*
*	REVISION HISTORY:
*		Author: Bill Fitler
*		Modifications for PCDOS 2.0  AS april,84
*		Dynamic checking for PC-DOS versions AS April,84
*		Split into separate files for pcdosb 12/84 JC
*		Replaced conditional compiled expressions 2/85 JC
*		Changed creat4 to dos2creat&setfd 3/85 JC
*
*/

#include	"portab.h"
#include	"osif.h"                        /* Include CP/M definitions */
#if CPMXPC1

int
creat (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	return(_creat1(fname,prot,0));		/* def to ascii */
}
int
creata (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	return(_creat1(fname,prot,0));		/* ascii */
}
int
creatb (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	return(_creat1(fname,prot,1));		/* binary */
}
#endif

#if PC2ONLY

int
creat (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	/* def to ascii */
	int	fd;

	fd = dos2creat(fname, 0);
	return(_setfd(fd,0,-1));
}
int
creata (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	/* ascii */

	int	fd;

	fd = dos2creat(fname, 0);
	return(_setfd(fd,0,-1));
}
int
creatb (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	/* binary */

	int	fd;

	fd = dos2creat(fname, 0);
	return(_setfd(fd,1,-1));
}
#endif

#if PCBOTH
#include	"osattr.h"
int
creat (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/
	int	fd;

	/* ascii */
	if(os_unixlike)
	{
		fd = dos2creat(fname, 0);
		return(_setfd(fd,0,-1));
	}
	else
		return(_creat1(fname,prot,0));
}
int
creata (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/

	int	fd;

	/* ascii */
	if(os_unixlike)
	{
		fd = dos2creat(fname, 0);
		return(_setfd(fd,0,-1));
	}
	else
		return(_creat1(fname,prot,0));
}
int
creatb (fname,prot)			/****************************/
char	*fname; 			/* -> File name 	    */
int	prot;				/* Open mode		    */
{					/****************************/

	int	fd;

	/* binary */
	if(os_unixlike)
	{
		fd = dos2creat(fname, 0);
		return(_setfd(fd,1,-1));
	}
	else
		return(_creat1(fname,prot,1));
}
#endif
                                                                                                       