/***************************************************************************
*
*		b l k m o v e   F u n c t i o n
*		-------------------------------
*	Copyright 1983, by Digital Research Inc.
*
*	"blkmove()" moves a block of bytes from one address to another.
*
*	Calling sequence:
*		eval = blkmove(to,from,nn)
*	Where:
*		'to' points to destination
*		'from' points to source, and
*		'nn' is the number of chars to move
*		'eval' points to end of moved region
*
*	Edits:
*	8-Feb-84 whf	return ptr to end of region.
*
***************************************************************************/
#include "portab.h"

BYTE *	blkmove(to,from,nn)			/* CLEAR FUNCTION ***********/
    BYTE *to, *from;
    UWORD nn;
{
	if( to < from ) {
		while(nn--)
			*to++ = *from++;
		return to;
	} else {
		for( to += nn, from += nn; nn--; )
			*--to = *--from;
		return to+nn;
	}
}
                                                                                                                        