/* conio.c	*/
/* console iosystem for lisa for DOSJR 12/16/84 */
/* goal of this module is to define routines:
	bconstat(h)					-- trap13, fnct 1 
	bconin(h)					-- trap13, fnct 2 
	bconout(h,parm is integer char value to display)-- trap13, fnct 3 
	coninit()
		where   h = a device in which {0 == prt, 1 == aux, 2 == cons}.
	cntrlst (flg)					-- trap13, fnct B
 */

#define BASE 0xF8000				/* screen base		*/
#define LINE 720				/* line size in bytes	*/
#define BOTTOM  0xFF8F0 			/* top raster of bottom line */
						/* keyboard mapping tables: */
extern char ctltbl[], capstbl[], shiftbl[], unshift[];	/* found in biosa.s */
extern char unshft1[], shift1[], scancd[], scancd1[], alt[];	/* " " "    */
extern int newdsk;

char *prntr  = { 0xfc6000 } ;		/* printer port */
char *kybd   = { 0xfcdd80 } ;		/* keyboard/mouse COPS (6522 VIA ?)*/
int  *vrtoff = { 0xfce018 } ; 		/* vrtoff[0] = off, vrtoff[1] = on */
				/* next we have addresses for AUX: device: */
char *scntla = { 0xfcd201 } ; 		/* serial port b - control reg */
char *sdataa = { 0xfcd205 } ; 		/* serial port b - data reg */
				/* for serial a, control is 203, data is 207 */

int  (*ratint)();		/* Ptr to fnctn handling user defined vectors */
				/* Set in biosa.s to equal vector 200.  It is */
				/* used for moving the mouse.		      */
char ratdat[3];			/* Mouse movement info.  The indexes mean: */
				/* 0 =mouse key down, 1= x dir, 2 = y direct  */

char kbstate;			/* bit mapped to show state of control keys: 
				   if bit = 0 key is up, if = 1 key is down   
				   bit 0 is ignorred (= Right Shift Key)
				   bit 1 is Left Shift Key
				   bit 2 is Control Key
				   bit 3 is Alt Key
				   bit 4 is Caps Lock Key
				   Goal is to provide info in GDOS compatbl form
				*/
int kdown;
int lastkey;			/* last key still down:  for autorepeat */
int tcamt;			/* timer tick counter for autorepeat */
int nxttmer;			/* value of timer tick counter f next go round*/
int keyflag;			/* boolean: iff recently char add to keybd buf*/

#define QSIZE 256

struct Q
{	/* structure for queueing the keyboard input in a circular buffer*/
	long	data[QSIZE];	/* this is the long character val input by usr*/
	int	front;		/* pointer to the front of the circular buffer*/
	int	rear;		/* pointer to the rear of the circular buffer */
	int	qcnt;		/* number of characters in the circular buffer*/
} kq;

/***********************************/

nq(ch,qptr)	/* put a character into kq.data[] keyboard  character buffer */
struct Q *qptr;	/* the "circular" keyboard buffer data structure */
long ch;	/* the 32 bit "character" which we got f keyboard */
{
	qptr -> data[(qptr -> rear)++] = ch ;	/* remove character f buffer*/
	if ((qptr -> rear) == QSIZE) 		/* wrap-around for circ buf */
	    qptr -> rear = 0;
	qptr -> qcnt++ ;		/* one more character in the buffer */
}

long dq(qptr)	/* takes a char from the keyboard character circular buffer */
struct Q *qptr;
{
	int q2;

	qptr -> qcnt-- ;		/* one less character in the buffer */
	q2 = qptr -> front++ ;		/* remove from front of buffer */
	if ((qptr -> front) == QSIZE)	/* wrap-around for circular buffer */
	    qptr -> front = 0;
	return(qptr -> data[q2]);	/* return char at front of buffer */
}


char pget()	/* get the second+ char in a multichar keyboard input */
{
	while (! (*(kybd + 0x1b) & 2)) ;	/* poll for second char */
	return(*(kybd+3));			/* return the next character */
}


kbdcmd(c)	/* sends a command to the keyboard COPS */
char c;		/* command to COPS, see fig 2-14 on pg 2-28 of Lisa HardWare M*/
{
	int i;

	kybd[7] = 0xff;				/* set latch do output */
	while (! (*(kybd + 1) & 0x40)) ;
	do {
		*(kybd + 0x1f) = c;
	} while( *(kybd+1) & 0x40);
	/* *(kybd + 7) = 0xff ; */
	for (i=0; i<8; i++);			/* delay ? */
	kybd[7] = 0; 				/* back to input */
}

modify(ch)	/* Update data structure for Control key Change of state */
char ch;	/* Scan Code of a Control Key */
{
	char k;					/* boolean */

	if (ch & 0x80)				/* T iff key was downpressed */
	    k = 1;				/* key pressed down */
	else k = 0;				/* key let up */
	switch(ch & 3)				/* examn lowest ordr scan code*/
	{
		case 0: if (k)			/* left option = ALT Key    */
			    kbstate |= 0x08;	/* set bit 3 */
			else kbstate &= 0xF7;	/* clear bit 3 */
			break;
		case 1: if (k)			/* alpha lock =  CAPS LOCK  */
			    kbstate |= 0x10;	/* set bit 4 */
			else kbstate &= 0xEF;	/* clear bit 4 */
			break;
		case 2: if (k)			/* SHIFT Key 		    */
			    kbstate |= 0x02;	/* set bit 1 */
			else kbstate &= 0xFD;	/* clear bit 1 */
			break;
		case 3:	if (k)			/* command = CONTROL Key    */
			    kbstate |= 0x04;	/* set bit 2 */
			else kbstate &= 0xFB;	/* clear bit 2 */
		default: return;		/* no other valid scan codes*/
	}
}

		/* When a keyboard interrupt occurs, the interrupt is       */
		/* vectored over to keyint in biosa.s which saves the first */
		/* three address and data registers on the stack and then   */
		/* calls this procedure here.  Thus, this procedure handles */
keyint()	/* all of the keyboard interrupt handling.  It receives a   */
{		/* scan code value and outputs the appropriate activity/val */
	char c1;
	char c;
	int downr,icnt;

	c = *(kybd + 3);		/* get current "scancode" from keybd */
	icnt = kq.qcnt;			/* # of chars in the keyboard buffer */
	c1 = c & 0x7f ;			/* mask off t direction bit of scancd*/
	if (c == 0x80) 			/* T iff next char = spec reset char */
	{
	     c = pget(); 			/* reset code, get other part */
	     if (c == 0xfb)		/*T iff user desires to soft power off*/
	         kbdcmd (0x20);		/* Turn the power off -- EWF 4/26/85 */
					/* if not soft power off then ignore */
	}
	else if (c == 0)		/* T iff have a mouse event */
	{				/* it signals that mouse data follows*/
		ratdat[1] = pget();	/* 2nd char = change in x direction  */
		ratdat[2] = pget();	/* 3rd char = change in y direction  */
		(*ratint)(ratdat);	/* move mouse w vector 200h 	     */
	}
	else if (c1 >= 0x7c) 		/* T iff is shift, alt, cmd-type key */
	    modify(c);  		/* modifier key */
	else
	{
		downr = c & 0x80;	/* = 1 if key pressed down, else = 0 */
		if (c1 == 6)		/* mouse button key */
		{
			ratdat[0] = (downr == 0 ? 0 : 1);
			ratdat[1] = ratdat[2] = 0;	/* no mouse movement */
			(*ratint)(ratdat);
		}
		if (! downr) 		/* T iff key is now up */
		{
		    if ((c1 == 0x2c) && (kbstate & 0x08))/*Alt(. in keypad)key*/
		    {				/* simulates the mouse button */
			ratdat [0] = 0;			/* key is up */
			ratdat[1] = ratdat[2] = 0;	/* no mouse movement */
			(*ratint)(ratdat);
		    }
		    else if (c1 == lastkey)
		    {
			kdown = 0;
		    }
		}
		else			/* key is regular kb key pushed down */
		{
		    if ((c1 == 0x2c) && (kbstate & 0x08))/*Alt(. in keypad)key*/
		    {				/* simulates the mouse button */
			ratdat [0] = 1;			/* key is down */
			ratdat[1] = ratdat[2] = 0;	/* no mouse movement */
			(*ratint)(ratdat);
		    }
		    else
		    {
			tcamt = 25;		/* reinitialize count number */
			nxttmer = 10;
			kdown = 1;
			lastkey = c1;	/* preserve in case of autorepeat */
			addchar (c1);	/* add char into keybd buffer */
		    }
		}			/* end of else key pressed down */
	}				/* end of else is now reg kb key */
	if (icnt < kq.qcnt) keyflag = 1;
}

addchar (c1)	/* this is where the character is actually added to the buffer*/
int	c1;	/* lisa scan code of character to be added to keyboard buffer */
{
	char oops;
	long key;

	key = 0L;					/* initialize */
	if (c1 >= 0x40)
	{
		key |= scancd[c1 - 0x40];     		/* get IBM scncd*/
		key <<= 16;
		if (kbstate & 0x04)			/* CONTROL key*/
			key |= ctltbl[c1 - 0x40];
		else if (kbstate & 0x02)		/* SHIFT key  */
			key |= shiftbl[c1 - 0x40];
		else if (kbstate & 0x10)		/* CAPS LOCK  */
			key |= capstbl[c1 - 0x40];
		else if (kbstate & 0x08)		/* ALT key    */
		{
			key |= alt[c1 - 0x40];
			key <<= 16;
			key &= 0x00ff0000;
		}
		else key |= unshift[c1 - 0x40];		/* unshifted */

		nq (key, &kq);
	}
	else if ((c1 >= 0x20) && (c1 < 0x30)) 
	{
		if ((kbstate & 0x04) && (c1 == 0x2f))	/* CNTRL*/
		{
		    popit(newdsk = 1);   		/* pop out floppy*/
		    return;
		}
		if (kbstate & 0x08) 			/* Alt key depressed */
		{					/* mouse simulation */
		    oops = 0;				/* boolean init to F */
		    if (c1 == 0x22)			/* left arrow */
		    {
		        if (kbstate & 0x02)		/*caps key dep*/
			   ratdat[1] = -1;
			else ratdat[1] = -10;		/* x direction*/
			ratdat [2] = 0;			/* y direction*/
			oops = 1;
		    }
		    else if (c1 == 0x23)		/* right arrow*/
		    {
		        if (kbstate & 0x02)		/*caps key dep*/
			   ratdat[1] = 1;
			else ratdat [1] = 10;		/* x direction*/
			ratdat [2] = 0;			/* y direction*/
			oops = 1;
		    }
		    else if (c1 == 0x27)		/* up arrow*/
		    {
		        if (kbstate & 0x02)		/*caps key dep*/
			   ratdat[2] = -1;
			else ratdat [2] = -10;		/* y direction*/
			ratdat [1] = 0;			/* x direction*/
			oops = 1;
		    }
		    else if (c1 == 0x2b)		/* down arrow*/
		    {
		        if (kbstate & 0x02)		/*caps key dep*/
			   ratdat[2] = 1;
			else ratdat [2] = 10;		/* y direction*/
			ratdat [1] = 0;			/* x direction*/
			oops = 1;
		    }
		    if (oops)			/*T iff simulated mouse action*/
		    {
			(*ratint) (ratdat);
			return;
		    }
		}				/* end of if Alt key depressed*/
		key |= scancd1[c1 - 0x20];
		key <<= 16;
		if (! kbstate)				/* not shifted at all */
		    key |= unshft1[c1-0x20];
		else key |= shift1[c1-0x20];

		nq (key, &kq);
	}				/* end of else if scan key < 0x30 */
}
			
tmertck ()	/* called whenever a timer tick occurs f purpose of autorepeat*/
{
	if (kdown <= 0)			/* no key is pressed down at present */
	    return;	
	if ( ! (--tcamt))		/* T iff time for autorepeat */
	{
	    tcamt = nxttmer;		/* slightly faster next time */
	    if (nxttmer > 4)		/* incrementl autorepeating adjustment*/
		nxttmer-= 2;
	    else nxttmer = 2;
	    addchar (lastkey);		/* print out the last character again*/
	    keyflag = 1;		/* something new has been added to buf*/
	}
}

			/* this function outputs a character to a device   */
long bconout(h,chx)	/* trap13, function 3; no return until char output */
int h;			/* h spec device: 0 if PRN:, 1 if AUX:, 2 if CON:  */
int chx;		/* character val to output in low 8 bits of the word */
{
	char x;

	if (h == 1)		/* for the AUX: device */
	{
	    x = *scntla;	/* get contents of control reg of ser port b */
	    while (!(auxget(0) & 4));
	    *sdataa = chx;	/* write t char to the data reg of ser port b*/
	    return;
	}
				/* for all other devices */
	return(con_out(h,chx));
}

long
cntrlst (flg)	/* This is trap13, fnct B.  It alters the control status var */
int  flg;	/* if -1, inquiry only; else set according to flg */
{
	long  tmp;

	tmp = 0;			/* initialize = make sure no garbage */
	tmp |= kbstate;			/* preserve the current value */
	if ( flg != -1)			/* user wants to alter current val */
	    kbstate = flg;		/* alter the current value */
	return (tmp);
}

auxcmd(reg,val)
int reg,val;
{
	*scntla = reg;		/* write the val of reg into control register */
	*scntla = val;		/* write the value of val into the data regis */
}

auxget(reg)
int reg;
{
	*scntla = reg;		/* write the val of reg into control register */
	return(*scntla);	/* return the value in the data register */
}

			/* this is the check character input status routine */
long bconstat(h)	/* trap13, function 1; ret -1 device is ready else 0 */
int h;			/* h spec device: 0 if PRN:, 1 if AUX:, 2 if CON:  */
{
	if (h == 2)				/* device is CON: = console */
	{
		if (kq.qcnt) 			/* T iff contents in kb buf */
		    return (0xff);
		return(0);
	}
	if (h == 1)				/* device is AUX:  */
	{
		if (auxget(0) & 1) 
		    return(0xff);
		return(0);
	}
	else return (0);			/* device is PRN: */
}

			/* This is the routine to handle character input =   */
			/* trap13, function 2.  If h == 2 then we have the   */
long bconin(h)		/* 2.0 scan code in the low byte of the high word    */
int h;			/* h spec device: 0 if PRN:, 1 if AUX:, 2 if CON:    */
{
	char c;


	if (h == 1)				/* device is AUX: */
	{
		while( ! bconstat (h));
		return( *sdataa);
	}
		/* wait until get key from keyboard if none there in buffer */
	if (h == 2) 				/* device is CON: */
	{
	    if ( ! kq.qcnt) 			/* T iff no char in the kb buf*/
	    {					/* This is for polling  kb buf*/
	        keyflag = 0;			/* signl no kb input yet--EWF */
	        while ( ! keyflag);		/* keyflag set to T when get  */
	    }					/* char from keyint ()	      */
	    return( dq (&kq));
	}
						/*ignors any other device spec*/
}

long charout (h)	/* trap 13, function 8 */
int h;			/* 0: PRN; 1: AUX; 2: CON */
{
	if (h > 3) return (0L);		/* bad device: thus it is not ready */
	return (-1L);			/* hard code for ready */
}


coninit()
{
	char *via,x;

	kq.front = kq.rear = kq.qcnt = 0;	/* setup keyboard buffer */
	kbstate = 0;			/* zero out all bits */
	tcamt = 25;			/* initialize timer tick amount */
	nxttmer = 10;			/* for incremental auto repeating */
	kdown = 0; 			/* system used to start w cr key down*/
	kybd[0x05] = 0x0e; 		/* ddrb (pb1-3) is speaker volume */
	kybd[0x17] = 0x01; 		/* acr (pa latch enable) */
	kybd[0x19] = 0xc9; 		/*pcr (ca2 handshake,ca1 active ^edge)*/
	kybd[0x1d] = 0x7d; 		/* enable ca1 interrupt */
	kybd[0x07] = 0x00; 		/* ddra all input */
		/* now co-routine bconout(1); */
		/* nmi key  will now equal A1 = press down - on keypad key */
	kbdcmd(0x5a);			/* set high nibble of nmi key */
	kbdcmd(0x61);			/* set low nibble of nmi key */
		/* rat ints (7f for enable, 28 ms) */
	kbdcmd(0x7f);			/* 70 for no rat ints */
	vrtoff[0] = 0; 			/* turn off the bleeding blinkers */
	esc_init();			/* found in lisaesc.s */
		/* now init the aux */
	x = *scntla;			/* obtain value in control register */
		/* auxcmd( 9,0xc2);  no HW reset in a debug environment */
	auxcmd( 9,0x4a); 		/* 8a for serial a, 4a for serial b */
	auxcmd(11,0x50);
	auxcmd(14,0x03);
	auxcmd(13,0x00);
	auxcmd(12,0x0b);
	auxcmd( 4,0x44);
	auxcmd(10,0x00);
	auxcmd( 3,0xc1);
	auxcmd( 5,0xe8);
	auxcmd( 1,0x00); 		/* disable ints */
}

